/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaFormView;
import org.iplass.mtp.impl.view.generic.MetaViewControlSetting;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.ViewControlSetting;

@XmlRootElement
public class MetaEntityView
extends BaseRootMetaData
implements DefinableMetaData<EntityView> {
    private static final long serialVersionUID = -2770147037258806116L;
    private String definitionId;
    private List<MetaFormView> views;
    private List<MetaViewControlSetting> viewControlSettings;

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public List<MetaFormView> getViews() {
        if (this.views == null) {
            this.views = new ArrayList<MetaFormView>();
        }
        return this.views;
    }

    public void setViews(List<MetaFormView> views) {
        this.views = views;
    }

    public void addView(MetaFormView view) {
        this.getViews().add(view);
    }

    public List<MetaViewControlSetting> getViewControlSettings() {
        if (this.viewControlSettings == null) {
            this.viewControlSettings = new ArrayList<MetaViewControlSetting>();
        }
        return this.viewControlSettings;
    }

    public void setViewControlSettings(List<MetaViewControlSetting> viewControlSettings) {
        this.viewControlSettings = viewControlSettings;
    }

    public void addViewControlSetting(MetaViewControlSetting viewControlSetting) {
        this.getViewControlSettings().add(viewControlSetting);
    }

    public MetaEntityView copy() {
        return (MetaEntityView)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public EntityViewRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new EntityViewRuntime(this);
    }

    public void applyConfig(EntityView entityView) {
        EntityContext eContext = EntityContext.getCurrentContext();
        MetaEntity metaEntity = eContext.getHandlerByName(entityView.getDefinitionName()).getMetaData();
        this.name = entityView.getName();
        this.displayName = entityView.getDisplayName();
        this.description = entityView.getDescription();
        this.definitionId = metaEntity.getId();
        if (entityView.getViews().size() > 0) {
            for (FormView view : entityView.getViews()) {
                MetaFormView mView = MetaFormView.createInstance(view);
                mView.applyConfig(view, this.definitionId);
                this.addView(mView);
            }
            this.getViews().sort(Comparator.comparing(MetaFormView::getTypeName).thenComparing(Comparator.comparing(MetaFormView::getName, Comparator.nullsFirst(Comparator.naturalOrder()))));
        }
        if (!entityView.getViewControlSettings().isEmpty()) {
            for (ViewControlSetting viewControlSetting : entityView.getViewControlSettings()) {
                MetaViewControlSetting meta = new MetaViewControlSetting();
                meta.applyConfig(viewControlSetting);
                this.addViewControlSetting(meta);
            }
        }
    }

    public EntityView currentConfig() {
        EntityView entityView = new EntityView();
        entityView.setName(this.name);
        entityView.setDisplayName(this.displayName);
        entityView.setDescription(this.description);
        EntityContext eContext = EntityContext.getCurrentContext();
        EntityHandler eh = eContext.getHandlerById(this.definitionId);
        if (eh != null) {
            entityView.setDefinitionName(eh.getMetaData().getName());
        }
        if (this.getViews().size() > 0) {
            for (MetaFormView mv : this.getViews()) {
                FormView formView = mv.currentConfig(this.definitionId);
                entityView.addView(formView);
            }
        }
        if (!this.getViewControlSettings().isEmpty()) {
            for (MetaViewControlSetting meta : this.getViewControlSettings()) {
                ViewControlSetting viewControlSetting = meta.currentConfig();
                entityView.addViewControlSetting(viewControlSetting);
            }
        }
        return entityView;
    }
}

