/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaBulkFormView;
import org.iplass.mtp.impl.view.generic.MetaDetailFormView;
import org.iplass.mtp.impl.view.generic.MetaSearchFormView;
import org.iplass.mtp.impl.view.generic.element.MetaButton;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.impl.view.generic.element.section.MetaMassReferenceSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaReferenceSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.element.Button;
import org.iplass.mtp.view.generic.element.section.MassReferenceSection;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;
import org.iplass.mtp.view.generic.element.section.Section;

@XmlSeeAlso(value={MetaDetailFormView.class, MetaSearchFormView.class, MetaBulkFormView.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class MetaFormView
implements MetaData {
    private static final long serialVersionUID = -1033584608508358891L;
    private String name;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean localizationData;
    private boolean dialogMaximize;
    private List<MetaSection> sections;
    private String imageColor;
    private String iconTag;
    private List<MetaButton> buttons;
    @XmlTransient
    String scriptKey;

    public static MetaFormView createInstance(FormView view) {
        if (view instanceof DetailFormView) {
            return MetaDetailFormView.createInstance(view);
        }
        if (view instanceof SearchFormView) {
            return MetaSearchFormView.createInstance(view);
        }
        if (view instanceof BulkFormView) {
            return MetaBulkFormView.createInstance(view);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isLocalizationData() {
        return this.localizationData;
    }

    public void setLocalizationData(boolean localizationData) {
        this.localizationData = localizationData;
    }

    public boolean isDialogMaximize() {
        return this.dialogMaximize;
    }

    public void setDialogMaximize(boolean dialogMaximize) {
        this.dialogMaximize = dialogMaximize;
    }

    public List<MetaSection> getSections() {
        if (this.sections == null) {
            this.sections = new ArrayList<MetaSection>();
        }
        return this.sections;
    }

    public void setSections(List<MetaSection> sections) {
        this.sections = sections;
    }

    public void addSection(MetaSection section) {
        if (this.sections == null) {
            this.sections = new ArrayList<MetaSection>();
        }
        this.sections.add(section);
    }

    public String getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(String imageColor) {
        this.imageColor = imageColor;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public void setIconTag(String iconTag) {
        this.iconTag = iconTag;
    }

    public List<MetaButton> getButtons() {
        if (this.buttons == null) {
            this.buttons = new ArrayList<MetaButton>();
        }
        return this.buttons;
    }

    public void setButtons(List<MetaButton> buttons) {
        this.buttons = buttons;
    }

    public void addButton(MetaButton button) {
        this.getButtons().add(button);
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public MetaFormView copy() {
        return (MetaFormView)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public abstract void applyConfig(FormView var1, String var2);

    protected void fillFrom(FormView form, String definitionId) {
        MetaElement meta;
        this.name = form.getName();
        this.title = form.getTitle();
        this.localizationData = form.isLocalizationData();
        this.dialogMaximize = form.isDialogMaximize();
        this.imageColor = form.getImageColor();
        this.iconTag = form.getIconTag();
        for (Button button : form.getButtons()) {
            meta = new MetaButton();
            ((MetaButton)meta).applyConfig(button, definitionId);
            this.addButton((MetaButton)meta);
        }
        if (form.getSections().size() > 0) {
            for (Section section : form.getSections()) {
                meta = MetaSection.createInstance(section);
                meta.applyConfig(section, definitionId);
                if (section instanceof ReferenceSection) {
                    MetaReferenceSection rs = (MetaReferenceSection)meta;
                    if (rs.getPropertyId() == null) continue;
                    this.addSection(rs);
                    continue;
                }
                if (section instanceof MassReferenceSection) {
                    MetaMassReferenceSection ms = (MetaMassReferenceSection)meta;
                    if (ms.getPropertyId() == null) continue;
                    this.addSection(ms);
                    continue;
                }
                this.addSection((MetaSection)meta);
            }
        }
        this.localizedTitleList = I18nUtil.toMeta(form.getLocalizedTitleList());
    }

    public abstract FormView currentConfig(String var1);

    protected void fillTo(FormView form, String definitionId) {
        form.setScriptKey(this.scriptKey);
        form.setName(this.name);
        form.setTitle(this.title);
        form.setLocalizationData(this.localizationData);
        form.setDialogMaximize(this.dialogMaximize);
        form.setImageColor(this.imageColor);
        form.setIconTag(this.iconTag);
        for (MetaButton button : this.getButtons()) {
            form.addButton((Button)button.currentConfig(definitionId));
        }
        if (this.getSections().size() > 0) {
            for (MetaSection section : this.getSections()) {
                Section s = (Section)section.currentConfig(definitionId);
                if (s == null) continue;
                form.addSection(s);
            }
        }
        form.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
    }

    public FormViewRuntime createRuntime(EntityViewRuntime entityView) {
        return new FormViewRuntime(this, entityView);
    }

    public String getTypeName() {
        return this.getClass().getSimpleName();
    }
}

