/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.view.csv.CsvFileNameGroovyTemplateBinding;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.MetaFormView;
import org.iplass.mtp.impl.view.generic.MetaSearchFormView;
import org.iplass.mtp.impl.view.generic.element.section.MetaSearchConditionSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.util.StringUtil;

public class SearchFormViewRuntime
extends FormViewRuntime {
    public static final String INIT_CONDTION_MAP_BINDING_NAME = "initCondMap";
    public static final String REQUEST_BINDING_NAME = "request";
    public static final String SESSION_BINDING_NAME = "session";
    public static final String USER_BINDING_NAME = "user";
    private static final String SCRIPT_PREFIX = "SearchFormViewHandler_defaultPropertyConditionScript";
    private List<SectionRuntime> sections;
    private Script compiledDefaultPropertyConditionScript;
    private GroovyTemplate compiledCsvFileNameScript;

    public SearchFormViewRuntime(MetaFormView metaData, EntityViewRuntime entityView) {
        super(metaData, entityView);
        MetaSearchFormView form = (MetaSearchFormView)metaData;
        this.sections = new ArrayList<SectionRuntime>();
        if (form.getTopSection1() != null) {
            this.sections.add(form.getTopSection1().createRuntime(entityView, this));
        }
        if (form.getTopSection2() != null) {
            this.sections.add(form.getTopSection2().createRuntime(entityView, this));
        }
        if (form.getCenterSection() != null) {
            this.sections.add(form.getCenterSection().createRuntime(entityView, this));
        }
        if (form.getBottomSection() != null) {
            this.sections.add(form.getBottomSection().createRuntime(entityView, this));
        }
        if (form.getSections() != null) {
            MetaSearchConditionSection condSection = null;
            for (MetaSection section : form.getSections()) {
                if (!(section instanceof MetaSearchConditionSection)) continue;
                condSection = (MetaSearchConditionSection)section;
                break;
            }
            if (condSection != null) {
                String scriptName;
                ScriptEngine scriptEngine;
                if (condSection.getDefaultPropertyConditionScript() != null) {
                    scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                    scriptName = null;
                    scriptName = metaData.getName() == null || metaData.getName().isEmpty() ? "SearchFormViewHandler_defaultPropertyConditionScript_" + entityView.getMetaData().getId() + "_default" : "SearchFormViewHandler_defaultPropertyConditionScript_" + entityView.getMetaData().getId() + "_" + metaData.getName();
                    this.compiledDefaultPropertyConditionScript = scriptEngine.createScript(condSection.getDefaultPropertyConditionScript(), scriptName);
                }
                if (condSection.getCsvdownloadFileNameFormat() != null) {
                    scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                    scriptName = null;
                    scriptName = metaData.getName() == null || metaData.getName().isEmpty() ? "_" + entityView.getMetaData().getId() + "_SearchFormView_csvFileNameScript_default" : "_" + entityView.getMetaData().getId() + "_SearchFormView_csvFileNameScript_" + metaData.getName();
                    this.compiledCsvFileNameScript = GroovyTemplateCompiler.compile((String)condSection.getCsvdownloadFileNameFormat(), (String)scriptName, (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
                }
            }
        }
    }

    public Map<String, Object> applyDefaultPropertyCondition(Map<String, Object> defaultCondMap) {
        if (this.compiledDefaultPropertyConditionScript == null) {
            return defaultCondMap;
        }
        HashMap<String, Object> dynamicCondMap = new HashMap<String, Object>();
        if (defaultCondMap != null) {
            dynamicCondMap.putAll(defaultCondMap);
        }
        UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
        ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        ScriptContext sc = scriptEngine.newScriptContext();
        sc.setAttribute(INIT_CONDTION_MAP_BINDING_NAME, dynamicCondMap);
        sc.setAttribute(REQUEST_BINDING_NAME, (Object)RequestContextBinding.newRequestContextBinding());
        sc.setAttribute(SESSION_BINDING_NAME, (Object)SessionBinding.newSessionBinding());
        sc.setAttribute(USER_BINDING_NAME, (Object)user);
        this.compiledDefaultPropertyConditionScript.eval(sc);
        return this.valueToArray(dynamicCondMap);
    }

    public String getCsvDownloadFileName(String defaultName, Map<String, Object> csvVariableMap) {
        if (this.compiledCsvFileNameScript == null) {
            return defaultName;
        }
        StringWriter sw = new StringWriter();
        try {
            this.compiledCsvFileNameScript.doTemplate((GroovyTemplateBinding)new CsvFileNameGroovyTemplateBinding(sw, defaultName, csvVariableMap));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String fileName = sw.toString();
        if (StringUtil.isNotEmpty((String)fileName)) {
            fileName = StringUtil.removeLineFeedCode((String)StringUtil.deleteWhitespace((String)fileName)).replaceAll("\t", "");
        }
        return fileName;
    }

    private Map<String, Object> valueToArray(Map<String, Object> dynamicCondMap) {
        if (dynamicCondMap == null) {
            return null;
        }
        for (Map.Entry<String, Object> e : dynamicCondMap.entrySet()) {
            dynamicCondMap.put(e.getKey(), this.toArray(e.getValue()));
        }
        return dynamicCondMap;
    }

    private Object toArray(Object value) {
        if (value != null && !value.getClass().isArray()) {
            Object[] array = (Object[])Array.newInstance(value.getClass(), 1);
            array[0] = value;
            return array;
        }
        return value;
    }
}

