/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.common;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.common.MetaAutocompletionSetting;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.common.AutocompletionSetting;
import org.iplass.mtp.view.generic.common.WebApiAutocompletionSetting;

public class MetaWebApiAutocompletionSetting
extends MetaAutocompletionSetting {
    private static final long serialVersionUID = 2616264117606562266L;
    private WebApiAutocompletionSetting.AutocompletionType autocompletionType;
    private String eql;
    private String groovyscript;

    public static MetaAutocompletionSetting createInstance(AutocompletionSetting setting) {
        return new MetaWebApiAutocompletionSetting();
    }

    public WebApiAutocompletionSetting.AutocompletionType getAutocompletionType() {
        return this.autocompletionType;
    }

    public void setAutocompletionType(WebApiAutocompletionSetting.AutocompletionType autocompletionType) {
        this.autocompletionType = autocompletionType;
    }

    public String getEql() {
        return this.eql;
    }

    public void setEql(String eql) {
        this.eql = eql;
    }

    public String getGroovyscript() {
        return this.groovyscript;
    }

    public void setGroovyscript(String groovyscript) {
        this.groovyscript = groovyscript;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    @Override
    public void applyConfig(AutocompletionSetting setting, EntityHandler entity, EntityHandler rootEntity) {
        super.fillFrom(setting, entity, rootEntity);
        WebApiAutocompletionSetting _setting = (WebApiAutocompletionSetting)setting;
        this.autocompletionType = _setting.getAutocompletionType();
        this.eql = _setting.getEql();
        this.groovyscript = _setting.getGroovyscript();
    }

    @Override
    public AutocompletionSetting currentConfig(EntityHandler entity, EntityHandler rootEntity) {
        WebApiAutocompletionSetting setting = new WebApiAutocompletionSetting();
        super.fillTo(setting, entity, rootEntity);
        setting.setAutocompletionType(this.autocompletionType);
        setting.setEql(this.eql);
        setting.setGroovyscript(this.groovyscript);
        return setting;
    }

    @Override
    public MetaAutocompletionSetting.AutocompletionSettingRuntime createRuntime(EntityViewRuntime entityView) {
        return new WebApiAutocompletionSettingRuntime((MetaAutocompletionSetting)this, entityView);
    }

    public class WebApiAutocompletionSettingRuntime
    extends MetaAutocompletionSetting.AutocompletionSettingRuntime {
        public static final String USER_BINDING_NAME = "user";
        public static final String PARAMS_BINDING_NAME = "params";
        public static final String CURRENT_VALUE_BINDING_NAME = "currentValue";
        public static final String AUTOCOMPLETION_EQL = "WebApiAutocompletion_eql";
        public static final String AUTOCOMPLETION_GROOVYSCRIPT = "WebApiAutocompletion_groovyscript";
        private GroovyTemplate eqlTemplate;
        private Script groovyscriptScript;

        public WebApiAutocompletionSettingRuntime(MetaAutocompletionSetting metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            if (WebApiAutocompletionSetting.AutocompletionType.EQL.equals((Object)this.getMetaData().getAutocompletionType()) && StringUtil.isNotEmpty((String)MetaWebApiAutocompletionSetting.this.eql)) {
                String templateKey = "WebApiAutocompletion_eql_" + entityView.getMetaData().getId() + GroovyTemplateCompiler.randomName().replace("-", "_");
                this.eqlTemplate = GroovyTemplateCompiler.compile((String)MetaWebApiAutocompletionSetting.this.eql, (String)templateKey, (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
                metadata.setRuntimeKey(templateKey);
            }
            if (WebApiAutocompletionSetting.AutocompletionType.GROOVYSCRIPT.equals((Object)this.getMetaData().getAutocompletionType()) && StringUtil.isNotEmpty((String)MetaWebApiAutocompletionSetting.this.groovyscript)) {
                String scriptKey = "WebApiAutocompletion_groovyscript_" + entityView.getMetaData().getId() + GroovyTemplateCompiler.randomName().replace("-", "_");
                this.groovyscriptScript = scriptEngine.createScript(MetaWebApiAutocompletionSetting.this.groovyscript, scriptKey);
                metadata.setRuntimeKey(scriptKey);
            }
        }

        @Override
        public Object handle(Map<String, String[]> param, Object currentValue, boolean isReference) {
            if (WebApiAutocompletionSetting.AutocompletionType.EQL.equals((Object)this.getMetaData().getAutocompletionType())) {
                return this.handleEql(param, currentValue, isReference);
            }
            if (WebApiAutocompletionSetting.AutocompletionType.GROOVYSCRIPT.equals((Object)this.getMetaData().getAutocompletionType())) {
                return this.handleGroovyScript(param, currentValue);
            }
            return null;
        }

        private Object handleEql(Map<String, String[]> param, Object currentValue, boolean isReference) {
            if (this.eqlTemplate == null) {
                return null;
            }
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            bindings.put(USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            bindings.put(PARAMS_BINDING_NAME, this.escapeEql(param));
            bindings.put(CURRENT_VALUE_BINDING_NAME, this.escapeEql(currentValue));
            StringWriter sw = new StringWriter();
            try {
                this.eqlTemplate.doTemplate(new GroovyTemplateBinding((Writer)sw, bindings));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String queryString = sw.toString();
            if (StringUtil.isEmpty((String)queryString)) {
                return null;
            }
            queryString = StringUtil.removeLineFeedCode((String)StringUtil.stripToEmpty((String)queryString)).replaceAll("\t", "");
            Query query = Query.newQuery((String)queryString);
            EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
            if (isReference) {
                SearchResult result = em.searchEntity(query);
                return result.getList();
            }
            SearchResult result = em.search(query);
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object[] data : result.getList()) {
                if (data.length <= 0) continue;
                ret.add(data[0]);
            }
            return ret;
        }

        private Object escapeEql(Object value) {
            if (value instanceof String) {
                return StringUtil.escapeEql((String)((String)value));
            }
            if (value instanceof String[]) {
                String[] array = (String[])value;
                return Arrays.stream(array).map(s -> StringUtil.escapeEql((String)s)).toArray();
            }
            if (value instanceof List) {
                List list = (List)value;
                return list.stream().map(s -> this.escapeEql(s)).collect(Collectors.toList());
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.escapeEql(entry.getValue()), (a, b) -> a, LinkedHashMap::new));
            }
            return value;
        }

        private Object handleGroovyScript(Map<String, String[]> param, Object currentValue) {
            if (this.groovyscriptScript == null) {
                return null;
            }
            UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(USER_BINDING_NAME, (Object)user);
            sc.setAttribute(PARAMS_BINDING_NAME, param);
            sc.setAttribute(CURRENT_VALUE_BINDING_NAME, currentValue);
            Object val = this.groovyscriptScript.eval(sc);
            return val;
        }

        @Override
        public MetaWebApiAutocompletionSetting getMetaData() {
            return (MetaWebApiAutocompletionSetting)super.getMetaData();
        }
    }
}

