/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaPrimitivePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class MetaBooleanPropertyEditor
extends MetaPrimitivePropertyEditor {
    private static final long serialVersionUID = -480791731251388954L;
    private BooleanPropertyEditor.BooleanDisplayType displayType;
    private String trueLabel;
    private List<MetaLocalizedString> localizedTrueLabelList = new ArrayList<MetaLocalizedString>();
    private String falseLabel;
    private List<MetaLocalizedString> localizedFalseLabelList = new ArrayList<MetaLocalizedString>();
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaBooleanPropertyEditor createInstance(PropertyEditor editor) {
        return new MetaBooleanPropertyEditor();
    }

    public BooleanPropertyEditor.BooleanDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(BooleanPropertyEditor.BooleanDisplayType displayType) {
        this.displayType = displayType;
    }

    public String getTrueLabel() {
        return this.trueLabel;
    }

    public void setTrueLabel(String trueLabel) {
        this.trueLabel = trueLabel;
    }

    public String getFalseLabel() {
        return this.falseLabel;
    }

    public void setFalseLabel(String falseLabel) {
        this.falseLabel = falseLabel;
    }

    public List<MetaLocalizedString> getLocalizedTrueLabelList() {
        return this.localizedTrueLabelList;
    }

    public void setLocalizedTrueLabelList(List<MetaLocalizedString> localizedTrueLabelList) {
        this.localizedTrueLabelList = localizedTrueLabelList;
    }

    public List<MetaLocalizedString> getLocalizedFalseLabelList() {
        return this.localizedFalseLabelList;
    }

    public void setLocalizedFalseLabelList(List<MetaLocalizedString> localizedFalseLabelList) {
        this.localizedFalseLabelList = localizedFalseLabelList;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    public MetaBooleanPropertyEditor copy() {
        return (MetaBooleanPropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(PropertyEditor editor) {
        super.fillFrom(editor);
        BooleanPropertyEditor e = (BooleanPropertyEditor)editor;
        this.displayType = e.getDisplayType();
        this.trueLabel = e.getTrueLabel();
        this.falseLabel = e.getFalseLabel();
        this.localizedTrueLabelList = I18nUtil.toMeta(e.getLocalizedTrueLabelList());
        this.localizedFalseLabelList = I18nUtil.toMeta(e.getLocalizedFalseLabelList());
        this.insertWithLabelValue = e.isInsertWithLabelValue();
        this.updateWithLabelValue = e.isUpdateWithLabelValue();
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        BooleanPropertyEditor editor = new BooleanPropertyEditor();
        super.fillTo(editor);
        editor.setDisplayType(this.displayType);
        editor.setTrueLabel(this.trueLabel);
        editor.setFalseLabel(this.falseLabel);
        editor.setLocalizedTrueLabelList(I18nUtil.toDef(this.localizedTrueLabelList));
        editor.setLocalizedFalseLabelList(I18nUtil.toDef(this.localizedFalseLabelList));
        editor.setInsertWithLabelValue(this.insertWithLabelValue);
        editor.setUpdateWithLabelValue(this.updateWithLabelValue);
        return editor;
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                ExpressionProperty ep;
                if (pd == null) {
                    return true;
                }
                if (pd instanceof BooleanProperty) {
                    return true;
                }
                return pd instanceof ExpressionProperty && (ep = (ExpressionProperty)pd).getResultType() == PropertyDefinitionType.BOOLEAN;
            }
        };
    }
}

