/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaDateTimePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class MetaDatePropertyEditor
extends MetaDateTimePropertyEditor {
    private static final long serialVersionUID = 8195076567521958652L;
    private boolean hideButtonPanel;
    private boolean showWeekday;

    public static MetaDatePropertyEditor createInstance(PropertyEditor editor) {
        return new MetaDatePropertyEditor();
    }

    public boolean isHideButtonPanel() {
        return this.hideButtonPanel;
    }

    public boolean isShowWeekday() {
        return this.showWeekday;
    }

    public void setShowWeekday(boolean showWeekday) {
        this.showWeekday = showWeekday;
    }

    public void setHideButtonPanel(boolean hideButtonPanel) {
        this.hideButtonPanel = hideButtonPanel;
    }

    @Override
    public void applyConfig(PropertyEditor editor) {
        super.fillFrom(editor);
        DatePropertyEditor de = (DatePropertyEditor)editor;
        this.hideButtonPanel = de.isHideButtonPanel();
        this.showWeekday = de.isShowWeekday();
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        DatePropertyEditor editor = new DatePropertyEditor();
        super.fillTo(editor);
        editor.setHideButtonPanel(this.hideButtonPanel);
        editor.setShowWeekday(this.showWeekday);
        return editor;
    }

    public MetaDatePropertyEditor copy() {
        return (MetaDatePropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                ExpressionProperty ep;
                if (pd == null) {
                    return true;
                }
                if (pd instanceof DateProperty) {
                    return true;
                }
                return pd instanceof ExpressionProperty && (ep = (ExpressionProperty)pd).getResultType() == PropertyDefinitionType.DATE;
            }
        };
    }
}

