/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.HasEntityProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaCustomPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

public class MetaDateRangePropertyEditor
extends MetaCustomPropertyEditor
implements HasEntityProperty {
    private static final long serialVersionUID = 7750500799495855836L;
    private String objectId;
    private MetaPropertyEditor editor;
    private boolean inputNullFrom;
    private MetaPropertyEditor toEditor;
    private String toPropertyId;
    private String toPropertyDisplayName;
    private List<MetaLocalizedString> localizedToPropertyDisplayNameList = new ArrayList<MetaLocalizedString>();
    private boolean inputNullTo;
    private boolean equivalentInput;
    private String errorMessage;
    private List<MetaLocalizedString> localizedErrorMessageList = new ArrayList<MetaLocalizedString>();

    public static MetaDateRangePropertyEditor createInstance(PropertyEditor editor) {
        return new MetaDateRangePropertyEditor();
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public MetaPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(MetaPropertyEditor editor) {
        this.editor = editor;
    }

    public boolean isInputNullFrom() {
        return this.inputNullFrom;
    }

    public void setInputNullFrom(boolean inputNullFrom) {
        this.inputNullFrom = inputNullFrom;
    }

    public MetaPropertyEditor getToEditor() {
        return this.toEditor;
    }

    public void setToEditor(MetaPropertyEditor toEditor) {
        this.toEditor = toEditor;
    }

    public String getToPropertyId() {
        return this.toPropertyId;
    }

    public void setToPropertyId(String toPropertyId) {
        this.toPropertyId = toPropertyId;
    }

    public String getToPropertyDisplayName() {
        return this.toPropertyDisplayName;
    }

    public void setToPropertyDisplayName(String toPropertyDisplayName) {
        this.toPropertyDisplayName = toPropertyDisplayName;
    }

    public List<MetaLocalizedString> getLocalizedToPropertyDisplayNameList() {
        return this.localizedToPropertyDisplayNameList;
    }

    public void setLocalizedToPropertyDisplayNameList(List<MetaLocalizedString> localizedToPropertyDisplayNameList) {
        this.localizedToPropertyDisplayNameList = localizedToPropertyDisplayNameList;
    }

    public boolean isInputNullTo() {
        return this.inputNullTo;
    }

    public void setInputNullTo(boolean inputNullTo) {
        this.inputNullTo = inputNullTo;
    }

    public boolean isEquivalentInput() {
        return this.equivalentInput;
    }

    public void setEquivalentInput(boolean equivalentInput) {
        this.equivalentInput = equivalentInput;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public List<MetaLocalizedString> getLocalizedErrorMessageList() {
        return this.localizedErrorMessageList;
    }

    public void setLocalizedErrorMessageList(List<MetaLocalizedString> localizedErrorMessageList) {
        this.localizedErrorMessageList = localizedErrorMessageList;
    }

    @Override
    public void applyConfig(PropertyEditor _editor) {
        super.fillFrom(_editor);
        DateRangePropertyEditor e = (DateRangePropertyEditor)_editor;
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler entity = metaContext.getHandlerByName(e.getObjectName());
        this.objectId = entity.getMetaData().getId();
        if (e.getEditor() != null) {
            this.editor = MetaPropertyEditor.createInstance(e.getEditor());
            this.editor.applyConfig(e.getEditor());
        }
        if (e.getToEditor() != null) {
            this.toEditor = MetaPropertyEditor.createInstance(e.getEditor());
            this.toEditor.applyConfig(e.getToEditor());
        }
        this.setInputNullFrom(e.isInputNullFrom());
        this.setInputNullTo(e.isInputNullTo());
        this.setEquivalentInput(e.isEquivalentInput());
        this.toPropertyId = this.convertId(e.getToPropertyName(), metaContext, entity);
        this.setToPropertyDisplayName(e.getToPropertyDisplayName());
        this.localizedToPropertyDisplayNameList = I18nUtil.toMeta(e.getLocalizedToPropertyDisplayNameList());
        if (this.toPropertyId == null) {
            throw new MetaDataIllegalStateException("to property name is not defined.");
        }
        this.errorMessage = e.getErrorMessage();
        if (e.getLocalizedErrorMessageList() != null && !e.getLocalizedErrorMessageList().isEmpty()) {
            this.localizedErrorMessageList = I18nUtil.toMeta(e.getLocalizedErrorMessageList());
        }
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler entity = metaContext.getHandlerById(this.objectId);
        if (entity == null) {
            return null;
        }
        DateRangePropertyEditor _editor = new DateRangePropertyEditor();
        super.fillTo(_editor);
        _editor.setObjectName(entity.getMetaData().getName());
        if (this.editor != null) {
            _editor.setEditor(this.editor.currentConfig(propertyName));
        }
        if (this.toEditor != null) {
            _editor.setToEditor(this.toEditor.currentConfig(propertyName));
        }
        if (this.toPropertyId != null) {
            _editor.setToPropertyName(this.convertName(this.toPropertyId, metaContext, entity));
            _editor.setToPropertyDisplayName(this.toPropertyDisplayName);
        }
        _editor.setLocalizedToPropertyDisplayNameList(I18nUtil.toDef(this.localizedToPropertyDisplayNameList));
        _editor.setInputNullFrom(this.inputNullFrom);
        _editor.setInputNullTo(this.inputNullTo);
        _editor.setEquivalentInput(this.equivalentInput);
        _editor.setErrorMessage(this.errorMessage);
        if (this.localizedErrorMessageList != null && !this.localizedErrorMessageList.isEmpty()) {
            _editor.setLocalizedErrorMessageList(I18nUtil.toDef(this.localizedErrorMessageList));
        }
        return _editor;
    }

    public MetaDateRangePropertyEditor copy() {
        return (MetaDateRangePropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                return true;
            }
        };
    }
}

