/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.view.generic.editor.MetaDatePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaDateTimeFormatSetting;
import org.iplass.mtp.impl.view.generic.editor.MetaLocalizedDateTimeFormatSetting;
import org.iplass.mtp.impl.view.generic.editor.MetaPrimitivePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaTimePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaTimestampPropertyEditor;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.DateTimeFormatSetting;
import org.iplass.mtp.view.generic.editor.DateTimePropertyEditor;
import org.iplass.mtp.view.generic.editor.LocalizedDateTimeFormatSetting;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;

@XmlSeeAlso(value={MetaDatePropertyEditor.class, MetaTimePropertyEditor.class, MetaTimestampPropertyEditor.class})
public abstract class MetaDateTimePropertyEditor
extends MetaPrimitivePropertyEditor {
    private static final long serialVersionUID = 8195076567521958652L;
    private DateTimePropertyEditor.DateTimeDisplayType displayType;
    private MetaDateTimeFormatSetting datetimeFormat;
    private List<MetaLocalizedDateTimeFormatSetting> LocalizedDateTimeFormatList;
    private boolean singleDayCondition;
    private boolean hideSearchConditionFrom;
    private boolean hideSearchConditionTo;
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaDateTimePropertyEditor createInstance(PropertyEditor editor) {
        if (editor instanceof DatePropertyEditor) {
            return MetaDatePropertyEditor.createInstance(editor);
        }
        if (editor instanceof TimePropertyEditor) {
            return MetaTimePropertyEditor.createInstance(editor);
        }
        if (editor instanceof TimestampPropertyEditor) {
            return MetaTimestampPropertyEditor.createInstance(editor);
        }
        return null;
    }

    public DateTimePropertyEditor.DateTimeDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DateTimePropertyEditor.DateTimeDisplayType displayType) {
        this.displayType = displayType;
    }

    public MetaDateTimeFormatSetting getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public void setDatetimeFormat(MetaDateTimeFormatSetting datetimeFormatList) {
        this.datetimeFormat = datetimeFormatList;
    }

    public List<MetaLocalizedDateTimeFormatSetting> getLocalizedDateTimeFormatList() {
        return this.LocalizedDateTimeFormatList;
    }

    public void setLocalizedDateTimeFormatList(List<MetaLocalizedDateTimeFormatSetting> localizedDateTimeFormatList) {
        this.LocalizedDateTimeFormatList = localizedDateTimeFormatList;
    }

    public boolean isSingleDayCondition() {
        return this.singleDayCondition;
    }

    public void setSingleDayCondition(boolean singleDayCondition) {
        this.singleDayCondition = singleDayCondition;
    }

    public boolean isHideSearchConditionFrom() {
        return this.hideSearchConditionFrom;
    }

    public void setHideSearchConditionFrom(boolean hideSearchConditionFrom) {
        this.hideSearchConditionFrom = hideSearchConditionFrom;
    }

    public boolean isHideSearchConditionTo() {
        return this.hideSearchConditionTo;
    }

    public void setHideSearchConditionTo(boolean hideSearchConditionTo) {
        this.hideSearchConditionTo = hideSearchConditionTo;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    @Override
    protected void fillFrom(PropertyEditor editor) {
        super.fillFrom(editor);
        DateTimePropertyEditor e = (DateTimePropertyEditor)editor;
        this.displayType = e.getDisplayType();
        this.singleDayCondition = e.isSingleDayCondition();
        this.hideSearchConditionFrom = e.isHideSearchConditionFrom();
        this.hideSearchConditionTo = e.isHideSearchConditionTo();
        this.insertWithLabelValue = e.isInsertWithLabelValue();
        this.updateWithLabelValue = e.isUpdateWithLabelValue();
        if (e.getDatetimeFormat() != null) {
            MetaDateTimeFormatSetting metaDtf = new MetaDateTimeFormatSetting();
            metaDtf.setDatetimeFormat(e.getDatetimeFormat().getDatetimeFormat());
            if (e.getDatetimeFormat().getDatetimeLocale() != null) {
                metaDtf.setDatetimeLocale(e.getDatetimeFormat().getDatetimeLocale());
            }
            this.datetimeFormat = metaDtf;
        }
        if (e.getLocalizedDatetimeFormatList() != null) {
            ArrayList<MetaLocalizedDateTimeFormatSetting> metaList = new ArrayList<MetaLocalizedDateTimeFormatSetting>();
            for (LocalizedDateTimeFormatSetting ldf : e.getLocalizedDatetimeFormatList()) {
                MetaLocalizedDateTimeFormatSetting metaLdf = new MetaLocalizedDateTimeFormatSetting();
                metaLdf.setLangage(ldf.getLangage());
                metaLdf.setDateTimeFormat(ldf.getDateTimeFormat());
                metaLdf.setDateTimeFormatLocale(ldf.getDateTimeFormatLocale());
                metaList.add(metaLdf);
            }
            this.LocalizedDateTimeFormatList = metaList;
        }
    }

    @Override
    protected void fillTo(PropertyEditor editor) {
        super.fillTo(editor);
        DateTimePropertyEditor pe = (DateTimePropertyEditor)editor;
        pe.setDisplayType(this.displayType);
        pe.setSingleDayCondition(this.singleDayCondition);
        pe.setHideSearchConditionFrom(this.hideSearchConditionFrom);
        pe.setHideSearchConditionTo(this.hideSearchConditionTo);
        pe.setInsertWithLabelValue(this.insertWithLabelValue);
        pe.setUpdateWithLabelValue(this.updateWithLabelValue);
        if (this.datetimeFormat != null) {
            DateTimeFormatSetting defDtf = new DateTimeFormatSetting();
            defDtf.setDatetimeFormat(this.datetimeFormat.getDatetimeFormat());
            if (this.datetimeFormat.getDatetimeLocale() != null) {
                defDtf.setDatetimeLocale(this.datetimeFormat.getDatetimeLocale());
            }
            pe.setDatetimeFormat(defDtf);
        }
        if (this.LocalizedDateTimeFormatList != null) {
            ArrayList<LocalizedDateTimeFormatSetting> defList = new ArrayList<LocalizedDateTimeFormatSetting>();
            for (MetaLocalizedDateTimeFormatSetting metaLdf : this.LocalizedDateTimeFormatList) {
                LocalizedDateTimeFormatSetting defLdf = new LocalizedDateTimeFormatSetting();
                defLdf.setLangage(metaLdf.getLangage());
                defLdf.setDateTimeFormat(metaLdf.getDateTimeFormat());
                defLdf.setDateTimeFormatLocale(metaLdf.getDateTimeFormatLocale());
                defList.add(defLdf);
            }
            pe.setLocalizedDatetimeFormatList(defList);
        }
    }
}

