/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.HasMetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaCustomPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;

public class MetaJoinPropertyEditor
extends MetaCustomPropertyEditor
implements HasMetaNestProperty {
    private static final long serialVersionUID = 7750500799495855836L;
    private String objectId;
    private String format;
    private MetaPropertyEditor editor;
    private List<MetaNestProperty> properties;
    private boolean showNestPropertyErrors;

    public static MetaJoinPropertyEditor createInstance(PropertyEditor editor) {
        return new MetaJoinPropertyEditor();
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public MetaPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(MetaPropertyEditor editor) {
        this.editor = editor;
    }

    public List<MetaNestProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<MetaNestProperty>();
        }
        return this.properties;
    }

    public void setProperties(List<MetaNestProperty> properties) {
        this.properties = properties;
    }

    public void addProperty(MetaNestProperty property) {
        this.getProperties().add(property);
    }

    @Override
    public List<MetaNestProperty> getNestProperties() {
        return this.getProperties();
    }

    public boolean isShowNestPropertyErrors() {
        return this.showNestPropertyErrors;
    }

    public void setShowNestPropertyErrors(boolean showNestPropertyErrors) {
        this.showNestPropertyErrors = showNestPropertyErrors;
    }

    @Override
    public void applyConfig(PropertyEditor _editor) {
        super.fillFrom(_editor);
        JoinPropertyEditor e = (JoinPropertyEditor)_editor;
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler entity = metaContext.getHandlerByName(e.getObjectName());
        this.objectId = entity.getMetaData().getId();
        this.format = e.getFormat();
        this.showNestPropertyErrors = e.isShowNestPropertyErrors();
        this.editor = MetaPropertyEditor.createInstance(e.getEditor());
        if (e.getEditor() != null) {
            this.fillCustomPropertyEditor(e.getEditor(), e.getPropertyName(), metaContext, entity);
            this.editor.applyConfig(e.getEditor());
        }
        for (NestProperty nest : e.getProperties()) {
            MetaNestProperty mnp = new MetaNestProperty();
            mnp.applyConfig(nest, entity, null);
            if (mnp.getPropertyId() == null) continue;
            this.addProperty(mnp);
        }
    }

    private void fillCustomPropertyEditor(PropertyEditor editor, String propName, EntityContext context, EntityHandler entity) {
        PropertyHandler ph = entity.getProperty(propName, context);
        if (ph == null) {
            return;
        }
        if (editor instanceof ReferencePropertyEditor && ph instanceof ReferencePropertyHandler) {
            String objName = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(context).getMetaData().getName();
            ((ReferencePropertyEditor)editor).setObjectName(objName);
        }
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        EntityContext metaContext = EntityContext.getCurrentContext();
        EntityHandler entity = metaContext.getHandlerById(this.objectId);
        if (entity == null) {
            return null;
        }
        JoinPropertyEditor _editor = new JoinPropertyEditor();
        super.fillTo(_editor);
        _editor.setObjectName(entity.getMetaData().getName());
        _editor.setFormat(this.format);
        _editor.setShowNestPropertyErrors(this.showNestPropertyErrors);
        if (this.editor != null) {
            _editor.setEditor(this.editor.currentConfig(propertyName));
        }
        for (MetaNestProperty nest : this.getProperties()) {
            NestProperty np = nest.currentConfig(entity, null);
            if (np == null || np.getPropertyName() == null) continue;
            _editor.addProperty(np);
        }
        return _editor;
    }

    public MetaJoinPropertyEditor copy() {
        return (MetaJoinPropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                return true;
            }
        };
    }
}

