/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.view.generic.editor.LinkProperty;

public class MetaLinkProperty
implements MetaData {
    private static final long serialVersionUID = 7220193122853969208L;
    private String linkFromPropertyId;
    private String linkToPropertyId;

    public String getLinkFromPropertyId() {
        return this.linkFromPropertyId;
    }

    public void setLinkFromPropertyId(String linkFromPropertyId) {
        this.linkFromPropertyId = linkFromPropertyId;
    }

    public String getLinkToPropertyId() {
        return this.linkToPropertyId;
    }

    public void setLinkToPropertyId(String linkToPropertyId) {
        this.linkToPropertyId = linkToPropertyId;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public void applyConfig(LinkProperty linkProperty, EntityHandler entity, EntityHandler fromEntity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler fromProperty = fromEntity.getProperty(linkProperty.getLinkFromPropertyName(), ctx);
        if (fromProperty == null) {
            return;
        }
        PropertyHandler toProperty = entity.getProperty(linkProperty.getLinkToPropertyName(), ctx);
        if (toProperty == null) {
            return;
        }
        this.linkFromPropertyId = fromProperty.getId();
        this.linkToPropertyId = toProperty.getId();
    }

    public LinkProperty currentConfig(EntityHandler entity, EntityHandler fromEntity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler fromProperty = fromEntity.getPropertyById(this.linkFromPropertyId, ctx);
        if (fromProperty == null) {
            return null;
        }
        PropertyHandler toProperty = entity.getPropertyById(this.linkToPropertyId, ctx);
        if (toProperty == null) {
            return null;
        }
        LinkProperty linkProperty = new LinkProperty();
        linkProperty.setLinkFromPropertyName(fromProperty.getName());
        linkProperty.setLinkToPropertyName(toProperty.getName());
        return linkProperty;
    }
}

