/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.common.MetaAutocompletionSetting;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.view.generic.RequiredDisplayType;
import org.iplass.mtp.view.generic.TextAlign;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;

public class MetaNestProperty
implements MetaData {
    private static final long serialVersionUID = -5324754433567181221L;
    private String propertyId;
    private String displayLabel;
    private List<MetaLocalizedString> localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
    private String description;
    private List<MetaLocalizedString> localizedDescriptionList = new ArrayList<MetaLocalizedString>();
    private String tooltip;
    private List<MetaLocalizedString> localizedTooltipList = new ArrayList<MetaLocalizedString>();
    private int width;
    private TextAlign textAlign;
    private boolean hideDetail;
    private boolean hideView;
    private RequiredDisplayType requiredDisplayType;
    private boolean requiredNormal;
    private boolean requiredDetail;
    private boolean outputCsv = true;
    private MetaPropertyEditor editor;
    private MetaAutocompletionSetting autocompletionSetting;

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public RequiredDisplayType getRequiredDisplayType() {
        return this.requiredDisplayType;
    }

    public void setRequiredDisplayType(RequiredDisplayType requiredDisplayType) {
        this.requiredDisplayType = requiredDisplayType;
    }

    public boolean isRequiredNormal() {
        return this.requiredNormal;
    }

    public void setRequiredNormal(boolean requiredNormal) {
        this.requiredNormal = requiredNormal;
    }

    public boolean isRequiredDetail() {
        return this.requiredDetail;
    }

    public void setRequiredDetail(boolean requiredDetail) {
        this.requiredDetail = requiredDetail;
    }

    public boolean isOutputCsv() {
        return this.outputCsv;
    }

    public void setOutputCsv(boolean outputCsv) {
        this.outputCsv = outputCsv;
    }

    public MetaPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(MetaPropertyEditor editor) {
        this.editor = editor;
    }

    public MetaAutocompletionSetting getAutocompletionSetting() {
        return this.autocompletionSetting;
    }

    public void setAutocompletionSetting(MetaAutocompletionSetting autocompletionSetting) {
        this.autocompletionSetting = autocompletionSetting;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    public List<MetaLocalizedString> getLocalizedDescriptionList() {
        return this.localizedDescriptionList;
    }

    public void setLocalizedDescriptionList(List<MetaLocalizedString> localizedDescriptionList) {
        this.localizedDescriptionList = localizedDescriptionList;
    }

    public List<MetaLocalizedString> getLocalizedTooltipList() {
        return this.localizedTooltipList;
    }

    public void setLocalizedTooltipList(List<MetaLocalizedString> localizedTooltipList) {
        this.localizedTooltipList = localizedTooltipList;
    }

    public void applyConfig(NestProperty property, EntityHandler entity, EntityHandler rootEntity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler ph = entity.getProperty(property.getPropertyName(), ctx);
        if (ph == null) {
            return;
        }
        this.propertyId = ph.getId();
        this.displayLabel = property.getDisplayLabel();
        this.description = property.getDescription();
        this.tooltip = property.getTooltip();
        this.width = property.getWidth();
        this.textAlign = property.getTextAlign();
        this.hideDetail = property.isHideDetail();
        this.hideView = property.isHideView();
        this.requiredDisplayType = property.getRequiredDisplayType();
        this.requiredNormal = property.isRequiredNormal();
        this.requiredDetail = property.isRequiredDetail();
        this.outputCsv = property.isOutputCsv();
        MetaPropertyEditor editor = MetaPropertyEditor.createInstance(property.getEditor());
        if (property.getEditor() instanceof JoinPropertyEditor) {
            ((JoinPropertyEditor)property.getEditor()).setObjectName(entity.getMetaData().getName());
        } else if (property.getEditor() instanceof DateRangePropertyEditor) {
            ((DateRangePropertyEditor)property.getEditor()).setObjectName(entity.getMetaData().getName());
        } else if (property.getEditor() instanceof NumericRangePropertyEditor) {
            ((NumericRangePropertyEditor)property.getEditor()).setObjectName(entity.getMetaData().getName());
        } else if (property.getEditor() instanceof ReferencePropertyEditor && ph instanceof ReferencePropertyHandler) {
            String objName = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(ctx).getMetaData().getName();
            ((ReferencePropertyEditor)property.getEditor()).setObjectName(objName);
        }
        if (editor != null) {
            property.getEditor().setPropertyName(property.getPropertyName());
            editor.applyConfig(property.getEditor());
            this.editor = editor;
        }
        if (property.getAutocompletionSetting() != null) {
            this.autocompletionSetting = MetaAutocompletionSetting.createInstance(property.getAutocompletionSetting());
            this.autocompletionSetting.applyConfig(property.getAutocompletionSetting(), entity, rootEntity);
        }
        this.localizedDisplayLabelList = I18nUtil.toMeta(property.getLocalizedDisplayLabelList());
        this.localizedDescriptionList = I18nUtil.toMeta(property.getLocalizedDescriptionList());
        this.localizedTooltipList = I18nUtil.toMeta(property.getLocalizedTooltipList());
    }

    public NestProperty currentConfig(EntityHandler entity, EntityHandler rootEntity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler ph = entity.getPropertyById(this.propertyId, ctx);
        if (ph == null) {
            return null;
        }
        NestProperty property = new NestProperty();
        property.setPropertyName(ph.getName());
        property.setDisplayLabel(this.displayLabel);
        property.setDescription(this.description);
        property.setTooltip(this.tooltip);
        property.setWidth(this.width);
        property.setTextAlign(this.textAlign);
        property.setHideDetail(this.hideDetail);
        property.setHideView(this.hideView);
        property.setRequiredDisplayType(this.requiredDisplayType);
        property.setRequiredNormal(this.requiredNormal);
        property.setRequiredDetail(this.requiredDetail);
        property.setOutputCsv(this.outputCsv);
        if (this.editor != null) {
            property.setEditor(this.editor.currentConfig(ph.getName()));
        }
        if (this.autocompletionSetting != null) {
            property.setAutocompletionSetting(this.autocompletionSetting.currentConfig(entity, rootEntity));
        }
        property.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
        property.setLocalizedDescriptionList(I18nUtil.toDef(this.localizedDescriptionList));
        property.setLocalizedTooltipList(I18nUtil.toDef(this.localizedTooltipList));
        return property;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }
}

