/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaDecimalPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaFloatPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaIntegerPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPrimitivePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.NumberPropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;

@XmlSeeAlso(value={MetaDecimalPropertyEditor.class, MetaFloatPropertyEditor.class, MetaIntegerPropertyEditor.class})
public abstract class MetaNumberPropertyEditor
extends MetaPrimitivePropertyEditor {
    private static final long serialVersionUID = -9028002796797351149L;
    private NumberPropertyEditor.NumberDisplayType displayType;
    protected String numberFormat;
    protected boolean showComma;
    protected boolean searchInRange;
    protected int maxlength;
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaNumberPropertyEditor createInstance(PropertyEditor editor) {
        if (editor instanceof DecimalPropertyEditor) {
            return MetaDecimalPropertyEditor.createInstance(editor);
        }
        if (editor instanceof FloatPropertyEditor) {
            return MetaFloatPropertyEditor.createInstance(editor);
        }
        if (editor instanceof IntegerPropertyEditor) {
            return MetaIntegerPropertyEditor.createInstance(editor);
        }
        return null;
    }

    public NumberPropertyEditor.NumberDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(NumberPropertyEditor.NumberDisplayType displayType) {
        this.displayType = displayType;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public boolean isShowComma() {
        return this.showComma;
    }

    public void setShowComma(boolean showComma) {
        this.showComma = showComma;
    }

    public boolean isSearchInRange() {
        return this.searchInRange;
    }

    public void setSearchInRange(boolean searchInRange) {
        this.searchInRange = searchInRange;
    }

    public int getMaxlength() {
        return this.maxlength;
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    @Override
    protected void fillFrom(PropertyEditor editor) {
        super.fillFrom(editor);
        NumberPropertyEditor pe = (NumberPropertyEditor)editor;
        this.displayType = pe.getDisplayType();
        this.numberFormat = pe.getNumberFormat();
        this.showComma = pe.isShowComma();
        this.searchInRange = pe.isSearchInRange();
        this.maxlength = pe.getMaxlength();
        this.insertWithLabelValue = pe.isInsertWithLabelValue();
        this.updateWithLabelValue = pe.isUpdateWithLabelValue();
    }

    @Override
    protected void fillTo(PropertyEditor editor) {
        super.fillTo(editor);
        NumberPropertyEditor pe = (NumberPropertyEditor)editor;
        pe.setDisplayType(this.displayType);
        pe.setNumberFormat(this.numberFormat);
        pe.setShowComma(this.showComma);
        pe.setSearchInRange(this.searchInRange);
        pe.setMaxlength(this.maxlength);
        pe.setInsertWithLabelValue(this.insertWithLabelValue);
        pe.setUpdateWithLabelValue(this.updateWithLabelValue);
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                ExpressionProperty ep;
                if (pd == null) {
                    return true;
                }
                if (pd instanceof FloatProperty || pd instanceof IntegerProperty) {
                    return true;
                }
                return pd instanceof ExpressionProperty && ((ep = (ExpressionProperty)pd).getResultType() == PropertyDefinitionType.FLOAT || ep.getResultType() == PropertyDefinitionType.INTEGER);
            }
        };
    }
}

