/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.view.generic.editor.ReferenceComboSetting;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;

public class MetaReferenceComboSetting
implements MetaData {
    private static final long serialVersionUID = 2605708983437732896L;
    private String propertyId;
    private String condition;
    private MetaReferenceComboSetting parent;
    private String sortItem;
    private String displayLabelItem;
    private ReferencePropertyEditor.RefSortType sortType;

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public MetaReferenceComboSetting getParent() {
        return this.parent;
    }

    public void setParent(MetaReferenceComboSetting parent) {
        this.parent = parent;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public String getDisplayLabelItem() {
        return this.displayLabelItem;
    }

    public void setDisplayLabelItem(String displayLabelItem) {
        this.displayLabelItem = displayLabelItem;
    }

    public ReferencePropertyEditor.RefSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(ReferencePropertyEditor.RefSortType sortType) {
        this.sortType = sortType;
    }

    public void applyConfig(ReferenceComboSetting setting, EntityHandler entity) {
        PropertyHandler displayProperty;
        PropertyHandler sortProperty;
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler property = entity.getProperty(setting.getPropertyName(), ctx);
        if (property == null && !(property instanceof ReferencePropertyHandler)) {
            return;
        }
        ReferencePropertyHandler referenceProperty = (ReferencePropertyHandler)property;
        this.propertyId = referenceProperty.getId();
        this.condition = setting.getCondition();
        if (setting.getSortItem() != null && !setting.getSortItem().isEmpty() && (sortProperty = referenceProperty.getReferenceEntityHandler(ctx).getProperty(setting.getSortItem(), ctx)) != null) {
            this.sortItem = sortProperty.getId();
        }
        if (setting.getDisplayLabelItem() != null && !setting.getDisplayLabelItem().isEmpty() && (displayProperty = referenceProperty.getReferenceEntityHandler(ctx).getProperty(setting.getDisplayLabelItem(), ctx)) != null) {
            this.displayLabelItem = displayProperty.getId();
        }
        this.sortType = setting.getSortType();
        if (setting.getParent() != null && setting.getParent().getPropertyName() != null) {
            MetaReferenceComboSetting meta = new MetaReferenceComboSetting();
            meta.applyConfig(setting.getParent(), referenceProperty.getReferenceEntityHandler(ctx));
            if (meta.propertyId != null) {
                this.parent = meta;
            }
        }
    }

    public ReferenceComboSetting currentConfig(EntityHandler entity) {
        PropertyHandler displayProperty;
        PropertyHandler sortProperty;
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler property = entity.getPropertyById(this.propertyId, ctx);
        if (property == null && !(property instanceof ReferencePropertyHandler)) {
            return null;
        }
        ReferencePropertyHandler referenceProperty = (ReferencePropertyHandler)property;
        ReferenceComboSetting setting = new ReferenceComboSetting();
        setting.setPropertyName(referenceProperty.getName());
        setting.setCondition(this.condition);
        if (this.sortItem != null && (sortProperty = referenceProperty.getReferenceEntityHandler(ctx).getPropertyById(this.sortItem, ctx)) != null) {
            setting.setSortItem(sortProperty.getName());
        }
        if (this.displayLabelItem != null && (displayProperty = referenceProperty.getReferenceEntityHandler(ctx).getPropertyById(this.displayLabelItem, ctx)) != null) {
            setting.setDisplayLabelItem(displayProperty.getName());
        }
        setting.setSortType(this.sortType);
        if (this.parent != null && this.parent.propertyId != null) {
            setting.setParent(this.parent.currentConfig(referenceProperty.getReferenceEntityHandler(ctx)));
        }
        return setting;
    }
}

