/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.HasMetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaLinkProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaReferenceComboSetting;
import org.iplass.mtp.impl.view.generic.editor.MetaReferenceRecursiveTreeSetting;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;

public class MetaReferencePropertyEditor
extends MetaPropertyEditor
implements HasMetaNestProperty {
    private static final long serialVersionUID = 1640054951421530441L;
    private ReferencePropertyEditor.ReferenceDisplayType displayType;
    private boolean useSearchDialog;
    private boolean singleSelect;
    private boolean useNestConditionWithProperty;
    private String objectId;
    private String referenceFromObjectId;
    private List<MetaNestProperty> nestProperties;
    private boolean hideDeleteButton;
    private boolean hideRegistButton;
    private boolean hideSelectButton;
    private boolean editableReference;
    private ReferencePropertyEditor.InsertType insertType;
    private String viewrefActionName;
    private String detailrefActionName;
    private String selectActionName;
    private String addActionName;
    private String viewName;
    private String urlParameter;
    private List<ReferencePropertyEditor.UrlParameterActionType> urlParameterAction;
    @XmlTransient
    private String urlParameterScriptKey;
    private String sortItem;
    private ReferencePropertyEditor.RefSortType sortType;
    private ReferencePropertyEditor.EditPage editPage;
    private MetaReferenceComboSetting referenceComboSetting;
    private String selectActionCallbackScript;
    private String insertActionCallbackScript;
    private String addRowCallbackScript;
    private String condition;
    private ReferencePropertyEditor.RefComboSearchType searchType;
    private boolean showRefComboParent;
    private MetaReferenceRecursiveTreeSetting referenceRecursiveTreeSetting;
    private MetaLinkProperty linkProperty;
    private String specificVersionPropertyName;
    private String tableOrderPropertyId;
    private boolean forceUpadte;
    private boolean permitConditionSelectAll = true;
    private boolean permitVersionedSelect;
    private String displayLabelItem;
    private String uniqueItem;
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaReferencePropertyEditor createInstance(PropertyEditor editor) {
        return new MetaReferencePropertyEditor();
    }

    public ReferencePropertyEditor.ReferenceDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(ReferencePropertyEditor.ReferenceDisplayType displayType) {
        this.displayType = displayType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectName) {
        this.objectId = objectName;
    }

    public String getReferenceFromObjectId() {
        return this.referenceFromObjectId;
    }

    public void setReferenceFromObjectId(String referenceFromObjectId) {
        this.referenceFromObjectId = referenceFromObjectId;
    }

    public boolean isUseSearchDialog() {
        return this.useSearchDialog;
    }

    public void setUseSearchDialog(boolean useSearchDialog) {
        this.useSearchDialog = useSearchDialog;
    }

    public boolean isSingleSelect() {
        return this.singleSelect;
    }

    public void setSingleSelect(boolean singleSelect) {
        this.singleSelect = singleSelect;
    }

    public boolean isUseNestConditionWithProperty() {
        return this.useNestConditionWithProperty;
    }

    public void setUseNestConditionWithProperty(boolean useNestConditionWithProperty) {
        this.useNestConditionWithProperty = useNestConditionWithProperty;
    }

    @Override
    public List<MetaNestProperty> getNestProperties() {
        if (this.nestProperties == null) {
            this.nestProperties = new ArrayList<MetaNestProperty>();
        }
        return this.nestProperties;
    }

    public void setNestProperties(List<MetaNestProperty> nestProperties) {
        this.nestProperties = nestProperties;
    }

    public void addNestProperty(MetaNestProperty property) {
        this.getNestProperties().add(property);
    }

    public boolean isHideDeleteButton() {
        return this.hideDeleteButton;
    }

    public void setHideDeleteButton(boolean dispDeleteButton) {
        this.hideDeleteButton = dispDeleteButton;
    }

    public boolean isHideRegistButton() {
        return this.hideRegistButton;
    }

    public void setHideRegistButton(boolean dispRegistButton) {
        this.hideRegistButton = dispRegistButton;
    }

    public boolean isHideSelectButton() {
        return this.hideSelectButton;
    }

    public void setHideSelectButton(boolean hideSelectButton) {
        this.hideSelectButton = hideSelectButton;
    }

    public boolean isEditableReference() {
        return this.editableReference;
    }

    public void setEditableReference(boolean editableReference) {
        this.editableReference = editableReference;
    }

    public ReferencePropertyEditor.InsertType getInsertType() {
        return this.insertType;
    }

    public void setInsertType(ReferencePropertyEditor.InsertType insertType) {
        this.insertType = insertType;
    }

    public String getViewrefActionName() {
        return this.viewrefActionName;
    }

    public void setViewrefActionName(String viewrefActionName) {
        this.viewrefActionName = viewrefActionName;
    }

    public String getDetailrefActionName() {
        return this.detailrefActionName;
    }

    public void setDetailrefActionName(String detailrefActionName) {
        this.detailrefActionName = detailrefActionName;
    }

    public String getSelectActionName() {
        return this.selectActionName;
    }

    public void setSelectActionName(String selectActionName) {
        this.selectActionName = selectActionName;
    }

    public String getAddActionName() {
        return this.addActionName;
    }

    public void setAddActionName(String addActionName) {
        this.addActionName = addActionName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getUrlParameter() {
        return this.urlParameter;
    }

    public void setUrlParameter(String urlParameter) {
        this.urlParameter = urlParameter;
    }

    public List<ReferencePropertyEditor.UrlParameterActionType> getUrlParameterAction() {
        return this.urlParameterAction;
    }

    public void setUrlParameterAction(List<ReferencePropertyEditor.UrlParameterActionType> urlParameterAction) {
        this.urlParameterAction = urlParameterAction;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public ReferencePropertyEditor.RefSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(ReferencePropertyEditor.RefSortType sortType) {
        this.sortType = sortType;
    }

    public ReferencePropertyEditor.EditPage getEditPage() {
        return this.editPage;
    }

    public void setEditPage(ReferencePropertyEditor.EditPage editPage) {
        this.editPage = editPage;
    }

    public MetaReferenceComboSetting getReferenceComboSetting() {
        return this.referenceComboSetting;
    }

    public void setReferenceComboSetting(MetaReferenceComboSetting referenceComboSetting) {
        this.referenceComboSetting = referenceComboSetting;
    }

    public String getSelectActionCallbackScript() {
        return this.selectActionCallbackScript;
    }

    public void setSelectActionCallbackScript(String selectActionCallbackScript) {
        this.selectActionCallbackScript = selectActionCallbackScript;
    }

    public String getInsertActionCallbackScript() {
        return this.insertActionCallbackScript;
    }

    public void setInsertActionCallbackScript(String insertActionCallbackScript) {
        this.insertActionCallbackScript = insertActionCallbackScript;
    }

    public String getAddRowCallbackScript() {
        return this.addRowCallbackScript;
    }

    public void setAddRowCallbackScript(String addRowCallbackScript) {
        this.addRowCallbackScript = addRowCallbackScript;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public ReferencePropertyEditor.RefComboSearchType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(ReferencePropertyEditor.RefComboSearchType searchType) {
        this.searchType = searchType;
    }

    public boolean isShowRefComboParent() {
        return this.showRefComboParent;
    }

    public void setShowRefComboParent(boolean showRefComboParent) {
        this.showRefComboParent = showRefComboParent;
    }

    public MetaReferenceRecursiveTreeSetting getReferenceRecursiveTreeSetting() {
        return this.referenceRecursiveTreeSetting;
    }

    public void setReferenceRecursiveTreeSetting(MetaReferenceRecursiveTreeSetting referenceRecursiveTreeSetting) {
        this.referenceRecursiveTreeSetting = referenceRecursiveTreeSetting;
    }

    public MetaLinkProperty getLinkProperty() {
        return this.linkProperty;
    }

    public void setLinkProperty(MetaLinkProperty linkProperty) {
        this.linkProperty = linkProperty;
    }

    public String getSpecificVersionPropertyName() {
        return this.specificVersionPropertyName;
    }

    public void setSpecificVersionPropertyName(String specificVersionPropertyName) {
        this.specificVersionPropertyName = specificVersionPropertyName;
    }

    public String getTableOrderPropertyId() {
        return this.tableOrderPropertyId;
    }

    public void setTableOrderPropertyId(String tableOrderPropertyId) {
        this.tableOrderPropertyId = tableOrderPropertyId;
    }

    public boolean isForceUpadte() {
        return this.forceUpadte;
    }

    public void setForceUpadte(boolean forceUpadte) {
        this.forceUpadte = forceUpadte;
    }

    public boolean isPermitConditionSelectAll() {
        return this.permitConditionSelectAll;
    }

    public void setPermitConditionSelectAll(boolean permitConditionSelectAll) {
        this.permitConditionSelectAll = permitConditionSelectAll;
    }

    public boolean isPermitVersionedSelect() {
        return this.permitVersionedSelect;
    }

    public void setPermitVersionedSelect(boolean permitVersionedSelect) {
        this.permitVersionedSelect = permitVersionedSelect;
    }

    public String getDisplayLabelItem() {
        return this.displayLabelItem;
    }

    public void setDisplayLabelItem(String displayLabelItem) {
        this.displayLabelItem = displayLabelItem;
    }

    public String getUniqueKeyItem() {
        return this.uniqueItem;
    }

    public void setUniqueKeyItem(String uniqueKeyItem) {
        this.uniqueItem = uniqueKeyItem;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    @Override
    public void applyConfig(PropertyEditor editor) {
        super.fillFrom(editor);
        ReferencePropertyEditor rpe = (ReferencePropertyEditor)editor;
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler refEntity = context.getHandlerByName(rpe.getObjectName());
        EntityHandler fromEntity = null;
        if (rpe.getReferenceFromObjectName() != null) {
            fromEntity = context.getHandlerByName(rpe.getReferenceFromObjectName());
        }
        PropertyHandler sortProperty = null;
        if (rpe.getSortItem() != null) {
            sortProperty = refEntity.getProperty(rpe.getSortItem(), context);
        }
        this.displayType = rpe.getDisplayType();
        this.objectId = refEntity.getMetaData().getId();
        if (fromEntity != null) {
            this.referenceFromObjectId = fromEntity.getMetaData().getId();
        }
        PropertyHandler displayLabelProperty = null;
        if (rpe.getDisplayLabelItem() != null) {
            displayLabelProperty = refEntity.getProperty(rpe.getDisplayLabelItem(), context);
        }
        PropertyHandler uniqueProperty = null;
        if (rpe.getUniqueItem() != null) {
            uniqueProperty = refEntity.getProperty(rpe.getUniqueItem(), context);
        }
        this.useSearchDialog = rpe.isUseSearchDialog();
        this.singleSelect = rpe.isSingleSelect();
        this.useNestConditionWithProperty = rpe.isUseNestConditionWithProperty();
        this.hideDeleteButton = rpe.isHideDeleteButton();
        this.hideRegistButton = rpe.isHideRegistButton();
        this.hideSelectButton = rpe.isHideSelectButton();
        this.editableReference = rpe.isEditableReference();
        this.insertType = rpe.getInsertType();
        this.viewrefActionName = rpe.getViewrefActionName();
        this.detailrefActionName = rpe.getDetailrefActionName();
        this.selectActionName = rpe.getSelectActionName();
        this.addActionName = rpe.getAddActionName();
        this.viewName = rpe.getViewName();
        this.urlParameter = rpe.getUrlParameter();
        this.urlParameterAction = rpe.getUrlParameterAction() != null ? new ArrayList<ReferencePropertyEditor.UrlParameterActionType>(rpe.getUrlParameterAction()) : null;
        this.sortItem = sortProperty != null ? sortProperty.getId() : null;
        this.sortType = rpe.getSortType();
        this.editPage = rpe.getEditPage();
        this.selectActionCallbackScript = rpe.getSelectActionCallbackScript();
        this.insertActionCallbackScript = rpe.getInsertActionCallbackScript();
        this.addRowCallbackScript = rpe.getAddRowCallbackScript();
        this.condition = rpe.getCondition();
        this.searchType = rpe.getSearchType();
        this.showRefComboParent = rpe.isShowRefComboParent();
        this.specificVersionPropertyName = rpe.getSpecificVersionPropertyName();
        this.permitConditionSelectAll = rpe.isPermitConditionSelectAll();
        this.permitVersionedSelect = rpe.isPermitVersionedSelect();
        this.displayLabelItem = displayLabelProperty != null ? displayLabelProperty.getId() : null;
        String string = this.uniqueItem = uniqueProperty != null ? uniqueProperty.getId() : null;
        if (rpe.getTableOrderPropertyName() != null) {
            PropertyHandler tableOrderProperty = refEntity.getProperty(rpe.getTableOrderPropertyName(), context);
            this.tableOrderPropertyId = tableOrderProperty != null ? tableOrderProperty.getId() : null;
        }
        this.forceUpadte = rpe.isForceUpadte();
        for (NestProperty np : rpe.getNestProperties()) {
            MetaNestProperty mnp = new MetaNestProperty();
            mnp.applyConfig(np, refEntity, fromEntity);
            if (mnp.getPropertyId() == null) continue;
            this.addNestProperty(mnp);
        }
        if (rpe.getReferenceComboSetting() != null && rpe.getReferenceComboSetting().getPropertyName() != null) {
            MetaReferenceComboSetting tmp = new MetaReferenceComboSetting();
            tmp.applyConfig(rpe.getReferenceComboSetting(), refEntity);
            if (tmp.getPropertyId() != null) {
                this.referenceComboSetting = tmp;
            }
        }
        if (rpe.getReferenceRecursiveTreeSetting() != null) {
            MetaReferenceRecursiveTreeSetting setting = new MetaReferenceRecursiveTreeSetting();
            setting.applyConfig(rpe.getReferenceRecursiveTreeSetting(), refEntity);
            if (setting.getChildPropertyId() != null) {
                this.referenceRecursiveTreeSetting = setting;
            }
        }
        if (rpe.getLinkProperty() != null && fromEntity != null) {
            MetaLinkProperty link = new MetaLinkProperty();
            link.applyConfig(rpe.getLinkProperty(), refEntity, fromEntity);
            this.linkProperty = link;
        }
        this.insertWithLabelValue = rpe.isInsertWithLabelValue();
        this.updateWithLabelValue = rpe.isUpdateWithLabelValue();
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler refEntity = context.getHandlerById(this.objectId);
        if (refEntity == null) {
            return null;
        }
        EntityHandler fromEntity = null;
        if (this.referenceFromObjectId != null) {
            fromEntity = context.getHandlerById(this.referenceFromObjectId);
        }
        ReferencePropertyEditor editor = new ReferencePropertyEditor();
        super.fillTo(editor);
        PropertyHandler sortProperty = null;
        if (this.sortItem != null) {
            sortProperty = refEntity.getPropertyById(this.sortItem, context);
        }
        editor.setDisplayType(this.displayType);
        if (refEntity != null) {
            editor.setObjectName(refEntity.getMetaData().getName());
        }
        if (fromEntity != null) {
            editor.setReferenceFromObjectName(fromEntity.getMetaData().getName());
        }
        PropertyHandler displayLabelProperty = null;
        if (this.displayLabelItem != null) {
            displayLabelProperty = refEntity.getPropertyById(this.displayLabelItem, context);
        }
        PropertyHandler uniqueProperty = null;
        if (this.uniqueItem != null) {
            uniqueProperty = refEntity.getPropertyById(this.uniqueItem, context);
        }
        editor.setUseSearchDialog(this.useSearchDialog);
        editor.setSingleSelect(this.singleSelect);
        editor.setUseNestConditionWithProperty(this.useNestConditionWithProperty);
        editor.setHideDeleteButton(this.hideDeleteButton);
        editor.setHideRegistButton(this.hideRegistButton);
        editor.setHideSelectButton(this.hideSelectButton);
        editor.setEditableReference(this.editableReference);
        editor.setInsertType(this.insertType);
        editor.setViewrefActionName(this.viewrefActionName);
        editor.setDetailrefActionName(this.detailrefActionName);
        editor.setSelectActionName(this.selectActionName);
        editor.setAddActionName(this.addActionName);
        editor.setViewName(this.viewName);
        editor.setUrlParameter(this.urlParameter);
        editor.setUrlParameterAction((List<ReferencePropertyEditor.UrlParameterActionType>)(this.urlParameterAction != null ? new ArrayList<ReferencePropertyEditor.UrlParameterActionType>(this.urlParameterAction) : null));
        editor.setUrlParameterScriptKey(this.urlParameterScriptKey);
        editor.setSortItem(sortProperty != null ? sortProperty.getName() : null);
        editor.setSortType(this.sortType);
        editor.setEditPage(this.editPage);
        editor.setSelectActionCallbackScript(this.selectActionCallbackScript);
        editor.setInsertActionCallbackScript(this.insertActionCallbackScript);
        editor.setAddRowCallbackScript(this.addRowCallbackScript);
        editor.setCondition(this.condition);
        editor.setSearchType(this.searchType);
        editor.setShowRefComboParent(this.showRefComboParent);
        editor.setSpecificVersionPropertyName(this.specificVersionPropertyName);
        editor.setPermitConditionSelectAll(this.permitConditionSelectAll);
        editor.setPermitVersionedSelect(this.permitVersionedSelect);
        editor.setDisplayLabelItem(displayLabelProperty != null ? displayLabelProperty.getName() : null);
        editor.setUniqueItem(uniqueProperty != null ? uniqueProperty.getName() : null);
        if (this.tableOrderPropertyId != null) {
            PropertyHandler tableOrderProperty = refEntity.getPropertyById(this.tableOrderPropertyId, context);
            editor.setTableOrderPropertyName(tableOrderProperty != null ? tableOrderProperty.getName() : null);
        }
        editor.setForceUpadte(this.forceUpadte);
        for (MetaNestProperty mnp : this.getNestProperties()) {
            NestProperty np = mnp.currentConfig(refEntity, fromEntity);
            if (np == null || np.getPropertyName() == null) continue;
            editor.addNestProperty(np);
        }
        if (this.referenceComboSetting != null && this.referenceComboSetting.getPropertyId() != null) {
            editor.setReferenceComboSetting(this.referenceComboSetting.currentConfig(refEntity));
        }
        if (this.referenceRecursiveTreeSetting != null && this.referenceRecursiveTreeSetting.getChildPropertyId() != null) {
            editor.setReferenceRecursiveTreeSetting(this.referenceRecursiveTreeSetting.currentConfig(refEntity));
        }
        if (this.linkProperty != null && fromEntity != null) {
            editor.setLinkProperty(this.linkProperty.currentConfig(refEntity, fromEntity));
        }
        editor.setInsertWithLabelValue(this.insertWithLabelValue);
        editor.setUpdateWithLabelValue(this.updateWithLabelValue);
        return editor;
    }

    public MetaReferencePropertyEditor copy() {
        return (MetaReferencePropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new ReferencePropertyEditorRuntime(entityView, formView, propertyLayout, context, eh);
    }

    public class ReferencePropertyEditorRuntime
    extends MetaPropertyEditor.PropertyEditorRuntime {
        private static final String SCRIPT_PREFIX = "ReferencePropertyEditorHandler_urlParameter";
        private GroovyTemplate urlParameterScript;

        public ReferencePropertyEditorRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
            super(entityView, formView, propertyLayout, context, eh);
            if (StringUtil.isNotEmpty((String)MetaReferencePropertyEditor.this.urlParameter)) {
                MetaReferencePropertyEditor.this.urlParameterScriptKey = "ReferencePropertyEditor_UrlParameter_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.urlParameterScript = GroovyTemplateCompiler.compile((String)MetaReferencePropertyEditor.this.urlParameter, (String)(MetaReferencePropertyEditor.this.urlParameterScriptKey + "_" + SCRIPT_PREFIX), (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
                entityView.addTemplate(MetaReferencePropertyEditor.this.urlParameterScriptKey, this.urlParameterScript);
            }
            if (MetaReferencePropertyEditor.this.nestProperties != null && !MetaReferencePropertyEditor.this.nestProperties.isEmpty()) {
                for (MetaNestProperty meta : MetaReferencePropertyEditor.this.nestProperties) {
                    if (meta.getAutocompletionSetting() == null) continue;
                    entityView.addAutocompletionSetting(meta.getAutocompletionSetting().createRuntime(entityView));
                }
            }
        }

        @Override
        protected boolean checkPropertyType(PropertyDefinition pd) {
            return pd == null || pd instanceof ReferenceProperty;
        }
    }
}

