/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.view.generic.editor.ReferenceRecursiveTreeSetting;

public class MetaReferenceRecursiveTreeSetting
implements MetaData {
    private static final long serialVersionUID = 7607433679491145837L;
    private String rootCondition;
    private String childPropertyId;

    public String getRootCondition() {
        return this.rootCondition;
    }

    public void setRootCondition(String rootCondition) {
        this.rootCondition = rootCondition;
    }

    public String getChildPropertyId() {
        return this.childPropertyId;
    }

    public void setChildPropertyId(String childPropertyId) {
        this.childPropertyId = childPropertyId;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public void applyConfig(ReferenceRecursiveTreeSetting setting, EntityHandler entity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler property = entity.getProperty(setting.getChildPropertyName(), ctx);
        if (property == null && !(property instanceof ReferencePropertyHandler)) {
            return;
        }
        ReferencePropertyHandler referenceProperty = (ReferencePropertyHandler)property;
        this.rootCondition = setting.getRootCondition();
        this.childPropertyId = referenceProperty.getId();
    }

    public ReferenceRecursiveTreeSetting currentConfig(EntityHandler entity) {
        EntityContext ctx = EntityContext.getCurrentContext();
        PropertyHandler property = entity.getPropertyById(this.childPropertyId, ctx);
        if (property == null && !(property instanceof ReferencePropertyHandler)) {
            return null;
        }
        ReferencePropertyHandler referenceProperty = (ReferencePropertyHandler)property;
        ReferenceRecursiveTreeSetting setting = new ReferenceRecursiveTreeSetting();
        setting.setRootCondition(this.rootCondition);
        setting.setChildPropertyName(referenceProperty.getName());
        return setting;
    }
}

