/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaPrimitivePropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.EditorValue;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;

public class MetaSelectPropertyEditor
extends MetaPrimitivePropertyEditor {
    private static final long serialVersionUID = 5771547352037643009L;
    private SelectPropertyEditor.SelectDisplayType displayType;
    private List<EditorValue> values;
    private boolean sortCsvOutputValue;
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaSelectPropertyEditor createInstance(PropertyEditor editor) {
        return new MetaSelectPropertyEditor();
    }

    public SelectPropertyEditor.SelectDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(SelectPropertyEditor.SelectDisplayType displayType) {
        this.displayType = displayType;
    }

    public List<EditorValue> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<EditorValue>();
        }
        return this.values;
    }

    public void setValues(List<EditorValue> values) {
        this.values = values;
    }

    public boolean isSortCsvOutputValue() {
        return this.sortCsvOutputValue;
    }

    public void setSortCsvOutputValue(boolean sortCsvOutputValue) {
        this.sortCsvOutputValue = sortCsvOutputValue;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    public MetaSelectPropertyEditor copy() {
        return (MetaSelectPropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(PropertyEditor editor) {
        super.fillFrom(editor);
        SelectPropertyEditor pe = (SelectPropertyEditor)editor;
        this.displayType = pe.getDisplayType();
        this.values = pe.getValues();
        this.sortCsvOutputValue = pe.isSortCsvOutputValue();
        this.insertWithLabelValue = pe.isInsertWithLabelValue();
        this.updateWithLabelValue = pe.isUpdateWithLabelValue();
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        SelectPropertyEditor editor = new SelectPropertyEditor();
        super.fillTo(editor);
        editor.setDisplayType(this.displayType);
        editor.setValues(this.values);
        editor.setSortCsvOutputValue(this.sortCsvOutputValue);
        editor.setInsertWithLabelValue(this.insertWithLabelValue);
        editor.setUpdateWithLabelValue(this.updateWithLabelValue);
        return editor;
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                ExpressionProperty ep;
                if (pd == null) {
                    return true;
                }
                if (pd instanceof SelectProperty) {
                    return true;
                }
                return pd instanceof ExpressionProperty && (ep = (ExpressionProperty)pd).getResultType() == PropertyDefinitionType.SELECT;
            }
        };
    }
}

