/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.editor;

import java.io.Serializable;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaCustomPropertyEditor;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;

public class MetaUserPropertyEditor
extends MetaCustomPropertyEditor {
    private static final long serialVersionUID = -3636767642233881066L;
    private UserPropertyEditor.UserDisplayType displayType;
    private boolean insertWithLabelValue = true;
    private boolean updateWithLabelValue = false;

    public static MetaUserPropertyEditor createInstance(PropertyEditor editor) {
        return new MetaUserPropertyEditor();
    }

    public UserPropertyEditor.UserDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(UserPropertyEditor.UserDisplayType displayType) {
        this.displayType = displayType;
    }

    public boolean isInsertWithLabelValue() {
        return this.insertWithLabelValue;
    }

    public void setInsertWithLabelValue(boolean insertWithLabelValue) {
        this.insertWithLabelValue = insertWithLabelValue;
    }

    public boolean isUpdateWithLabelValue() {
        return this.updateWithLabelValue;
    }

    public void setUpdateWithLabelValue(boolean updateWithLabelValue) {
        this.updateWithLabelValue = updateWithLabelValue;
    }

    @Override
    public void applyConfig(PropertyEditor editor) {
        super.fillFrom(editor);
        UserPropertyEditor upe = (UserPropertyEditor)editor;
        this.displayType = upe.getDisplayType();
        this.insertWithLabelValue = upe.isInsertWithLabelValue();
        this.updateWithLabelValue = upe.isUpdateWithLabelValue();
    }

    @Override
    public PropertyEditor currentConfig(String propertyName) {
        UserPropertyEditor editor = new UserPropertyEditor();
        super.fillTo(editor);
        if (this.displayType == null) {
            editor.setDisplayType(UserPropertyEditor.UserDisplayType.LABEL);
        } else {
            editor.setDisplayType(this.displayType);
        }
        editor.setInsertWithLabelValue(this.insertWithLabelValue);
        editor.setUpdateWithLabelValue(this.updateWithLabelValue);
        return editor;
    }

    public MetaUserPropertyEditor copy() {
        return (MetaUserPropertyEditor)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public MetaDataRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView, MetaPropertyLayout propertyLayout, EntityContext context, EntityHandler eh) {
        return new MetaPropertyEditor.PropertyEditorRuntime(entityView, formView, propertyLayout, context, eh){

            @Override
            protected boolean checkPropertyType(PropertyDefinition pd) {
                return pd == null || pd instanceof StringProperty;
            }
        };
    }
}

