/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.OutputType;

public class ElementRuntime {
    private static final String REQUEST_BINDING_NAME = "request";
    private static final String SESSION_BINDING_NAME = "session";
    private static final String USER_BINDING_NAME = "user";
    private static final String OUTPUT_TYPE_BINDING_NAME = "outputType";
    private static final String ENTITY_BINDING_NAME = "entity";
    private static final String ELEMENT_GROOVYSCRIPT_PREFIX = "Element";
    private MetaElement metadata;
    private Script dispGroovyScript;

    public ElementRuntime(MetaElement metadata, EntityViewRuntime entityView) {
        this.metadata = metadata;
        String elementRuntimeId = "Element_" + entityView.getMetaData().getId() + "_" + GroovyTemplateCompiler.randomName().replace("-", "_");
        metadata.setElementRuntimeId(elementRuntimeId);
        if (StringUtil.isNotEmpty((String)metadata.getDisplayScript())) {
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            this.dispGroovyScript = scriptEngine.createScript(metadata.getDisplayScript(), elementRuntimeId);
        }
        entityView.addElement(this);
    }

    public MetaElement getMetaData() {
        return this.metadata;
    }

    public boolean isDisplay(OutputType outputType, Entity entity) {
        if (!this.metadata.isDispFlag()) {
            return false;
        }
        if (this.dispGroovyScript != null) {
            UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(REQUEST_BINDING_NAME, (Object)RequestContextBinding.newRequestContextBinding());
            sc.setAttribute(SESSION_BINDING_NAME, (Object)SessionBinding.newSessionBinding());
            sc.setAttribute(USER_BINDING_NAME, (Object)user);
            sc.setAttribute(OUTPUT_TYPE_BINDING_NAME, (Object)outputType);
            sc.setAttribute(ENTITY_BINDING_NAME, (Object)entity);
            boolean val = (Boolean)this.dispGroovyScript.eval(sc);
            return val;
        }
        return true;
    }
}

