/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.element.Button;
import org.iplass.mtp.view.generic.element.DisplayType;
import org.iplass.mtp.view.generic.element.Element;

public class MetaButton
extends MetaElement {
    private static final long serialVersionUID = -2033613830792032497L;
    private DisplayType displayType;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private String displayLabel;
    private List<MetaLocalizedString> localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
    private boolean primary = true;
    private String style;
    private String onclickEvent;
    private String inputCustomStyle;
    private String inputCustomStyleScriptKey;
    private String customDisplayTypeScript;
    private String customDisplayTypeScriptKey;

    public static MetaButton createInstance(Element element) {
        return new MetaButton();
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getOnclickEvent() {
        return this.onclickEvent;
    }

    public void setOnclickEvent(String onclickEvent) {
        this.onclickEvent = onclickEvent;
    }

    public String getInputCustomStyle() {
        return this.inputCustomStyle;
    }

    public void setInputCustomStyle(String inputCustomStyle) {
        this.inputCustomStyle = inputCustomStyle;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    @XmlTransient
    public String getInputCustomStyleScriptKey() {
        return this.inputCustomStyleScriptKey;
    }

    public void setInputCustomStyleScriptKey(String inputCustomStyleScriptKey) {
        this.inputCustomStyleScriptKey = inputCustomStyleScriptKey;
    }

    public String getCustomDisplayTypeScript() {
        return this.customDisplayTypeScript;
    }

    public void setCustomDisplayTypeScript(String customDisplayTypeScript) {
        this.customDisplayTypeScript = customDisplayTypeScript;
    }

    @XmlTransient
    public String getCustomDisplayTypeScriptKey() {
        return this.customDisplayTypeScriptKey;
    }

    public void setCustomDisplayTypeScriptKey(String customDisplayTypeScriptKey) {
        this.customDisplayTypeScriptKey = customDisplayTypeScriptKey;
    }

    public MetaButton copy() {
        return (MetaButton)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        Button button = (Button)element;
        this.displayType = button.getDisplayType();
        this.title = button.getTitle();
        this.displayLabel = button.getDisplayLabel();
        this.primary = button.isPrimary();
        this.style = button.getStyle();
        this.inputCustomStyle = button.getInputCustomStyle();
        this.onclickEvent = button.getOnclickEvent();
        this.customDisplayTypeScript = button.getCustomDisplayTypeScript();
        this.localizedTitleList = I18nUtil.toMeta(button.getLocalizedTitleList());
        this.localizedDisplayLabelList = I18nUtil.toMeta(button.getLocalizedDisplayLabelList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        Button button = new Button();
        super.fillTo(button, definitionId);
        button.setDisplayType(this.displayType);
        button.setTitle(this.title);
        button.setDisplayLabel(this.displayLabel);
        button.setPrimary(this.primary);
        button.setStyle(this.style);
        button.setOnclickEvent(this.onclickEvent);
        button.setInputCustomStyle(this.inputCustomStyle);
        button.setInputCustomStyleScriptKey(this.inputCustomStyleScriptKey);
        button.setCustomDisplayTypeScript(this.customDisplayTypeScript);
        button.setCustomDisplayTypeScriptKey(this.customDisplayTypeScriptKey);
        button.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        button.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
        return button;
    }

    @Override
    public ButtonRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new ButtonRuntime(this, entityView);
    }

    public class ButtonRuntime
    extends ElementRuntime {
        public static final String REQUEST_BINDING_NAME = "request";
        public static final String SESSION_BINDING_NAME = "session";
        public static final String USER_BINDING_NAME = "user";
        public static final String OUTPUT_TYPE_BINDING_NAME = "outputType";
        public static final String ENTITY_BINDING_NAME = "entity";
        private static final String SCRIPT_PREFIX_INPUT_CUSTOM_STYLE = "ButtonHandler_inputCustomStyle";
        private static final String SCRIPT_PREFIX_CUSTOM_DISPLAY_TYPE = "ButtonHandler_inputCustomStyle_customDisplayTypeScript";
        private GroovyTemplate inputCustomStyleScript;
        private Script compiledCustomDisplayTypeScript;

        public ButtonRuntime(MetaButton metadata, EntityViewRuntime entityView) {
            ScriptEngine scriptEngine;
            super(metadata, entityView);
            MetaButton.this.inputCustomStyleScriptKey = "Button_InputStyle" + GroovyTemplateCompiler.randomName().replace("-", "_");
            if (StringUtil.isNotEmpty((String)MetaButton.this.inputCustomStyle)) {
                scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.inputCustomStyleScript = GroovyTemplateCompiler.compile((String)MetaButton.this.inputCustomStyle, (String)(MetaButton.this.inputCustomStyleScriptKey + "_" + SCRIPT_PREFIX_INPUT_CUSTOM_STYLE), (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
            }
            if (StringUtil.isNotEmpty((String)MetaButton.this.customDisplayTypeScript)) {
                scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                String scriptName = "ButtonHandler_inputCustomStyle_customDisplayTypeScript_" + entityView.getMetaData().getId() + GroovyTemplateCompiler.randomName().replace("-", "_");
                this.compiledCustomDisplayTypeScript = scriptEngine.createScript(MetaButton.this.customDisplayTypeScript, scriptName);
                MetaButton.this.customDisplayTypeScriptKey = scriptName;
            }
            entityView.addButton(this);
        }

        public GroovyTemplate getInputCustomStyleScript() {
            return this.inputCustomStyleScript;
        }

        public boolean isDisplayButton(OutputType outputType, Entity entity) {
            if (this.compiledCustomDisplayTypeScript == null) {
                return false;
            }
            UserBinding user = AuthContextHolder.getAuthContext().newUserBinding();
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(REQUEST_BINDING_NAME, (Object)RequestContextBinding.newRequestContextBinding());
            sc.setAttribute(SESSION_BINDING_NAME, (Object)SessionBinding.newSessionBinding());
            sc.setAttribute(USER_BINDING_NAME, (Object)user);
            sc.setAttribute(OUTPUT_TYPE_BINDING_NAME, (Object)outputType);
            sc.setAttribute(ENTITY_BINDING_NAME, (Object)entity);
            Object val = this.compiledCustomDisplayTypeScript.eval(sc);
            if (val != null) {
                if (val instanceof Boolean) {
                    return (Boolean)val;
                }
                if (val instanceof String) {
                    return Boolean.parseBoolean((String)val);
                }
            }
            return false;
        }

        @Override
        public MetaButton getMetaData() {
            return (MetaButton)super.getMetaData();
        }
    }
}

