/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.Link;

public class MetaLink
extends MetaElement {
    private static final long serialVersionUID = 1819770758000735919L;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private String displayLabel;
    private List<MetaLocalizedString> localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
    private String url;
    private boolean dispNewWindow;
    private String inputCustomStyle;
    private String inputCustomStyleScriptKey;

    public static MetaLink createInstance(Element element) {
        return new MetaLink();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isDispNewWindow() {
        return this.dispNewWindow;
    }

    public void setDispNewWindow(boolean dispNewWindow) {
        this.dispNewWindow = dispNewWindow;
    }

    public String getInputCustomStyle() {
        return this.inputCustomStyle;
    }

    public void setInputCustomStyle(String inputCustomStyle) {
        this.inputCustomStyle = inputCustomStyle;
    }

    @XmlTransient
    public String getInputCustomStyleScriptKey() {
        return this.inputCustomStyleScriptKey;
    }

    public void setInputCustomStyleScriptKey(String inputCustomStyleScriptKey) {
        this.inputCustomStyleScriptKey = inputCustomStyleScriptKey;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    public MetaLink copy() {
        return (MetaLink)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        Link link = (Link)element;
        this.title = link.getTitle();
        this.displayLabel = link.getDisplayLabel();
        this.url = link.getUrl();
        this.dispNewWindow = link.isDispNewWindow();
        this.inputCustomStyle = link.getInputCustomStyle();
        this.localizedTitleList = I18nUtil.toMeta(link.getLocalizedTitleList());
        this.localizedDisplayLabelList = I18nUtil.toMeta(link.getLocalizedDisplayLabelList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        Link link = new Link();
        super.fillTo(link, definitionId);
        link.setTitle(this.title);
        link.setDisplayLabel(this.displayLabel);
        link.setUrl(this.url);
        link.setDispNewWindow(this.dispNewWindow);
        link.setInputCustomStyle(this.inputCustomStyle);
        link.setInputCustomStyleScriptKey(this.inputCustomStyleScriptKey);
        link.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        link.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
        return link;
    }

    @Override
    public LinkRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new LinkRuntime(this, entityView);
    }

    public class LinkRuntime
    extends ElementRuntime {
        private static final String SCRIPT_PREFIX = "LinkHandler_inputCustomStyle";
        private GroovyTemplate inputCustomStyleScript;

        public LinkRuntime(MetaLink metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            MetaLink.this.inputCustomStyleScriptKey = "Link_InputStyle_" + GroovyTemplateCompiler.randomName().replace("-", "_");
            if (StringUtil.isNotEmpty((String)MetaLink.this.inputCustomStyle)) {
                ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                this.inputCustomStyleScript = GroovyTemplateCompiler.compile((String)MetaLink.this.inputCustomStyle, (String)(MetaLink.this.inputCustomStyleScriptKey + "_" + SCRIPT_PREFIX), (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
            }
        }

        public GroovyTemplate getInputCustomStyleScript() {
            return this.inputCustomStyleScript;
        }
    }
}

