/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.ScriptingElement;

public class MetaScriptingElement
extends MetaElement {
    private static final long serialVersionUID = -1456163052715903895L;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean hideDetail;
    private boolean hideView;
    private String script;
    private String key;

    public static MetaScriptingElement createInstance(Element element) {
        return new MetaScriptingElement();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public MetaScriptingElement copy() {
        return (MetaScriptingElement)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        ScriptingElement script = (ScriptingElement)element;
        this.title = script.getTitle();
        this.hideDetail = script.isHideDetail();
        this.hideView = script.isHideView();
        this.script = script.getScript();
        this.localizedTitleList = I18nUtil.toMeta(script.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        ScriptingElement script = new ScriptingElement();
        super.fillTo(script, definitionId);
        script.setTitle(this.title);
        script.setHideDetail(this.hideDetail);
        script.setHideView(this.hideView);
        script.setScript(this.script);
        script.setKey(this.key);
        script.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return script;
    }

    @Override
    public ScriptingRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new ScriptingRuntime(this, entityView);
    }

    public class ScriptingRuntime
    extends ElementRuntime {
        public ScriptingRuntime(MetaScriptingElement metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            if (metadata.script != null && metadata.key == null) {
                metadata.key = "Jsp_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                entityView.addTemplate(MetaScriptingElement.this.key, this.compile(MetaScriptingElement.this.key));
            }
        }

        private GroovyTemplate compile(String key) {
            TenantContext tenant = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)this.getMetaData().script, (String)key, (GroovyScriptEngine)((GroovyScriptEngine)tenant.getScriptEngine()));
        }

        @Override
        public MetaScriptingElement getMetaData() {
            return (MetaScriptingElement)super.getMetaData();
        }
    }
}

