/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.TemplateElement;

public class MetaTemplateElement
extends MetaElement {
    private static final long serialVersionUID = 5268765562272038808L;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean hideDetail;
    private boolean hideView;
    private String templateName;

    public static MetaTemplateElement createInstance(Element element) {
        return new MetaTemplateElement();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public MetaElement copy() {
        return (MetaElement)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        TemplateElement template = (TemplateElement)element;
        this.title = template.getTitle();
        this.hideDetail = template.isHideDetail();
        this.hideView = template.isHideView();
        this.templateName = template.getTemplateName();
        this.localizedTitleList = I18nUtil.toMeta(template.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        TemplateElement template = new TemplateElement();
        super.fillTo(template, definitionId);
        template.setTitle(this.title);
        template.setHideDetail(this.hideDetail);
        template.setHideView(this.hideView);
        template.setTemplateName(this.templateName);
        template.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return template;
    }
}

