/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.view.generic.RequiredDisplayType;
import org.iplass.mtp.view.generic.TextAlign;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.VirtualPropertyItem;

public class MetaVirtualProperty
extends MetaElement {
    private static final long serialVersionUID = 9190843316518646290L;
    private String propertyName;
    private String displayLabel;
    private List<MetaLocalizedString> localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
    private String style;
    private String description;
    private List<MetaLocalizedString> localizedDescriptionList = new ArrayList<MetaLocalizedString>();
    private String tooltip;
    private List<MetaLocalizedString> localizedTooltipList = new ArrayList<MetaLocalizedString>();
    private boolean hideDetail;
    private boolean hideView;
    private RequiredDisplayType requiredDisplayType;
    private MetaPropertyEditor editor;
    private int width;
    private TextAlign textAlign;
    private boolean outputCsv = false;

    public static MetaVirtualProperty createInstance(Element element) {
        return new MetaVirtualProperty();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MetaLocalizedString> getLocalizedDescriptionList() {
        return this.localizedDescriptionList;
    }

    public void setLocalizedDescriptionList(List<MetaLocalizedString> localizedDescriptionList) {
        this.localizedDescriptionList = localizedDescriptionList;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public List<MetaLocalizedString> getLocalizedTooltipList() {
        return this.localizedTooltipList;
    }

    public void setLocalizedTooltipList(List<MetaLocalizedString> localizedTooltipList) {
        this.localizedTooltipList = localizedTooltipList;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public RequiredDisplayType getRequiredDisplayType() {
        return this.requiredDisplayType;
    }

    public void setRequiredDisplayType(RequiredDisplayType requiredDisplayType) {
        this.requiredDisplayType = requiredDisplayType;
    }

    public MetaPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(MetaPropertyEditor editor) {
        this.editor = editor;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isOutputCsv() {
        return this.outputCsv;
    }

    public void setOutputCsv(boolean outputCsv) {
        this.outputCsv = outputCsv;
    }

    public MetaVirtualProperty copy() {
        return (MetaVirtualProperty)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        VirtualPropertyItem property = (VirtualPropertyItem)element;
        super.fillFrom(property, definitionId);
        this.propertyName = property.getPropertyName();
        this.displayLabel = property.getDisplayLabel();
        this.style = property.getStyle();
        this.description = property.getDescription();
        this.tooltip = property.getTooltip();
        this.hideDetail = property.isHideDetail();
        this.hideView = property.isHideView();
        this.requiredDisplayType = property.getRequiredDisplayType();
        this.width = property.getWidth();
        this.textAlign = property.getTextAlign();
        this.outputCsv = property.isOutputCsv();
        MetaPropertyEditor editor = MetaPropertyEditor.createInstance(property.getEditor());
        if (editor != null) {
            property.getEditor().setPropertyName(this.propertyName);
            editor.applyConfig(property.getEditor());
            this.editor = editor;
        }
        this.localizedDisplayLabelList = I18nUtil.toMeta(property.getLocalizedDisplayLabelList());
        this.localizedDescriptionList = I18nUtil.toMeta(property.getLocalizedDescriptionList());
        this.localizedTooltipList = I18nUtil.toMeta(property.getLocalizedTooltipList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        VirtualPropertyItem property = new VirtualPropertyItem();
        super.fillTo(property, definitionId);
        property.setPropertyName(this.propertyName);
        property.setDisplayLabel(this.displayLabel);
        property.setStyle(this.style);
        property.setDescription(this.description);
        property.setTooltip(this.tooltip);
        property.setHideDetail(this.hideDetail);
        property.setHideView(this.hideView);
        property.setRequiredDisplayType(this.requiredDisplayType);
        property.setWidth(this.width);
        property.setTextAlign(this.textAlign);
        property.setOutputCsv(this.outputCsv);
        if (this.editor != null) {
            property.setEditor(this.editor.currentConfig(this.propertyName));
        }
        property.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
        property.setLocalizedDescriptionList(I18nUtil.toDef(this.localizedDescriptionList));
        property.setLocalizedTooltipList(I18nUtil.toDef(this.localizedTooltipList));
        return property;
    }
}

