/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.property;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.view.generic.NullOrderType;
import org.iplass.mtp.view.generic.RequiredDisplayType;
import org.iplass.mtp.view.generic.TextAlign;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetaPropertyColumn
extends MetaPropertyLayout {
    private static final long serialVersionUID = 1940139489715422445L;
    private int width;
    private NullOrderType nullOrderType;
    private TextAlign textAlign;
    private boolean outputCsv = true;
    private MetaPropertyEditor bulkUpdateEditor;
    private RequiredDisplayType bulkUpdateRequiredDisplayType;

    public static MetaPropertyColumn createInstance(Element element) {
        return new MetaPropertyColumn();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public NullOrderType getNullOrderType() {
        return this.nullOrderType;
    }

    public void setNullOrderType(NullOrderType nullOrderType) {
        this.nullOrderType = nullOrderType;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isOutputCsv() {
        return this.outputCsv;
    }

    public void setOutputCsv(boolean outputCsv) {
        this.outputCsv = outputCsv;
    }

    public MetaPropertyEditor getBulkUpdateEditor() {
        return this.bulkUpdateEditor;
    }

    public void setBulkUpdateEditor(MetaPropertyEditor bulkUpdateEditor) {
        this.bulkUpdateEditor = bulkUpdateEditor;
    }

    public RequiredDisplayType getBulkUpdateRequiredDisplayType() {
        return this.bulkUpdateRequiredDisplayType;
    }

    public void setBulkUpdateRequiredDisplayType(RequiredDisplayType bulkUpdateRequiredDisplayType) {
        this.bulkUpdateRequiredDisplayType = bulkUpdateRequiredDisplayType;
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        PropertyColumn p = (PropertyColumn)element;
        this.width = p.getWidth();
        this.nullOrderType = p.getNullOrderType();
        this.textAlign = p.getTextAlign();
        this.outputCsv = p.isOutputCsv();
        if (p.getBulkUpdateEditor() != null) {
            MetaPropertyEditor editor = MetaPropertyEditor.createInstance(p.getBulkUpdateEditor());
            EntityContext context = EntityContext.getCurrentContext();
            EntityHandler entity = context.getHandlerById(definitionId);
            this.fillCustomPropertyEditor(p.getBulkUpdateEditor(), p.getPropertyName(), context, entity);
            if (editor != null) {
                p.getBulkUpdateEditor().setPropertyName(p.getPropertyName());
                editor.applyConfig(p.getBulkUpdateEditor());
                this.bulkUpdateEditor = editor;
            }
        }
        this.bulkUpdateRequiredDisplayType = p.getBulkUpdateRequiredDisplayType();
    }

    @Override
    public Element currentConfig(String definitionId) {
        PropertyColumn p = new PropertyColumn();
        super.fillTo(p, definitionId);
        if (p.getEditor() == null) {
            return null;
        }
        if (p.getPropertyName() == null) {
            return null;
        }
        p.setWidth(this.width);
        p.setNullOrderType(this.nullOrderType);
        p.setTextAlign(this.textAlign);
        p.setOutputCsv(this.outputCsv);
        if (this.bulkUpdateEditor != null) {
            p.setBulkUpdateEditor(this.bulkUpdateEditor.currentConfig(p.getPropertyName()));
        }
        p.setBulkUpdateRequiredDisplayType(this.bulkUpdateRequiredDisplayType);
        return p;
    }
}

