/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.impl.view.generic.element.property.validation.MetaViewValidator;
import org.iplass.mtp.view.generic.RequiredDisplayType;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyItem;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetaPropertyItem
extends MetaPropertyLayout {
    private static final long serialVersionUID = 1940139489715422445L;
    private String description;
    private List<MetaLocalizedString> localizedDescriptionList = new ArrayList<MetaLocalizedString>();
    private String tooltip;
    private List<MetaLocalizedString> localizedTooltipList = new ArrayList<MetaLocalizedString>();
    private boolean hideNormalCondition;
    private boolean hideDetailCondition;
    private boolean hideDetail;
    private boolean hideView;
    private RequiredDisplayType requiredDisplayType;
    private boolean isBlank;
    private boolean requiredNormal;
    private boolean requiredDetail;
    private MetaViewValidator validator;

    public static MetaPropertyItem createInstance(Element element) {
        return new MetaPropertyItem();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public boolean isHideNormalCondition() {
        return this.hideNormalCondition;
    }

    public void setHideNormalCondition(boolean hideNormalCondition) {
        this.hideNormalCondition = hideNormalCondition;
    }

    public boolean isHideDetailCondition() {
        return this.hideDetailCondition;
    }

    public void setHideDetailCondition(boolean hideDetailCondition) {
        this.hideDetailCondition = hideDetailCondition;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public RequiredDisplayType getRequiredDisplayType() {
        return this.requiredDisplayType;
    }

    public void setRequiredDisplayType(RequiredDisplayType requiredDisplayType) {
        this.requiredDisplayType = requiredDisplayType;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public void setBlank(boolean isBlank) {
        this.isBlank = isBlank;
    }

    public boolean isRequiredNormal() {
        return this.requiredNormal;
    }

    public void setRequiredNormal(boolean requiredNormal) {
        this.requiredNormal = requiredNormal;
    }

    public boolean isRequiredDetail() {
        return this.requiredDetail;
    }

    public void setRequiredDetail(boolean requiredDetail) {
        this.requiredDetail = requiredDetail;
    }

    public MetaViewValidator getValidator() {
        return this.validator;
    }

    public void setValidator(MetaViewValidator validator) {
        this.validator = validator;
    }

    public List<MetaLocalizedString> getLocalizedDescriptionList() {
        return this.localizedDescriptionList;
    }

    public void setLocalizedDescriptionList(List<MetaLocalizedString> localizedDescriptionList) {
        this.localizedDescriptionList = localizedDescriptionList;
    }

    public List<MetaLocalizedString> getLocalizedTooltipList() {
        return this.localizedTooltipList;
    }

    public void setLocalizedTooltipList(List<MetaLocalizedString> localizedTooltipList) {
        this.localizedTooltipList = localizedTooltipList;
    }

    @Override
    public MetaPropertyItem copy() {
        return (MetaPropertyItem)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        PropertyItem prop = (PropertyItem)element;
        this.description = prop.getDescription();
        this.tooltip = prop.getTooltip();
        this.hideNormalCondition = prop.isHideNormalCondition();
        this.hideDetailCondition = prop.isHideDetailCondition();
        this.hideDetail = prop.isHideDetail();
        this.hideView = prop.isHideView();
        this.requiredDisplayType = prop.getRequiredDisplayType();
        this.isBlank = prop.isBlank();
        this.requiredNormal = prop.isRequiredNormal();
        this.requiredDetail = prop.isRequiredDetail();
        if (prop.getValidator() != null) {
            this.validator = MetaViewValidator.createInstance(prop.getValidator());
            this.validator.applyConfig(prop.getValidator(), definitionId);
        }
        this.localizedDescriptionList = I18nUtil.toMeta(prop.getLocalizedDescriptionList());
        this.localizedTooltipList = I18nUtil.toMeta(prop.getLocalizedTooltipList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        PropertyItem p = new PropertyItem();
        if (this.isBlank) {
            p.setDispFlag(this.isDispFlag());
            p.setBlank(this.isBlank);
            return p;
        }
        super.fillTo(p, definitionId);
        if (p.getEditor() == null) {
            return null;
        }
        if (p.getPropertyName() == null) {
            return null;
        }
        p.setDescription(this.description);
        p.setTooltip(this.tooltip);
        p.setHideNormalCondition(this.hideNormalCondition);
        p.setHideDetailCondition(this.hideDetailCondition);
        p.setHideDetail(this.hideDetail);
        p.setHideView(this.hideView);
        p.setRequiredDisplayType(this.requiredDisplayType);
        p.setRequiredNormal(this.requiredNormal);
        p.setRequiredDetail(this.requiredDetail);
        if (this.validator != null) {
            p.setValidator(this.validator.currentConfig(definitionId));
        }
        p.setLocalizedDescriptionList(I18nUtil.toDef(this.localizedDescriptionList));
        p.setLocalizedTooltipList(I18nUtil.toDef(this.localizedTooltipList));
        return p;
    }
}

