/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.HasEntityProperty;
import org.iplass.mtp.impl.view.generic.common.MetaAutocompletionSetting;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyColumn;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyItem;
import org.iplass.mtp.view.generic.editor.DateRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NumericRangePropertyEditor;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.ReferencePropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyBase;
import org.iplass.mtp.view.generic.element.property.PropertyColumn;
import org.iplass.mtp.view.generic.element.property.PropertyItem;

@XmlSeeAlso(value={MetaPropertyItem.class, MetaPropertyColumn.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class MetaPropertyLayout
extends MetaElement
implements HasEntityProperty {
    private static final long serialVersionUID = 1940139489715422445L;
    private String propertyId;
    private String displayLabel;
    private List<MetaLocalizedString> localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
    private String style;
    private MetaPropertyEditor editor;
    private MetaAutocompletionSetting autocompletionSetting;

    public static MetaPropertyLayout createInstance(Element element) {
        if (element instanceof PropertyItem) {
            return new MetaPropertyItem();
        }
        if (element instanceof PropertyColumn) {
            return new MetaPropertyColumn();
        }
        return null;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public MetaPropertyEditor getEditor() {
        return this.editor;
    }

    public void setEditor(MetaPropertyEditor editor) {
        this.editor = editor;
    }

    public MetaAutocompletionSetting getAutocompletionSetting() {
        return this.autocompletionSetting;
    }

    public void setAutocompletionSetting(MetaAutocompletionSetting autocompletionSetting) {
        this.autocompletionSetting = autocompletionSetting;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    public MetaPropertyLayout copy() {
        return (MetaPropertyLayout)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    protected void fillFrom(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        PropertyBase p = (PropertyBase)element;
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler entity = context.getHandlerById(definitionId);
        String id = this.convertId(p.getPropertyName(), context, entity);
        if (id != null) {
            this.propertyId = id;
        }
        this.style = p.getStyle();
        this.displayLabel = p.getDisplayLabel();
        MetaPropertyEditor editor = MetaPropertyEditor.createInstance(p.getEditor());
        this.fillCustomPropertyEditor(p.getEditor(), p.getPropertyName(), context, entity);
        if (editor != null) {
            p.getEditor().setPropertyName(p.getPropertyName());
            editor.applyConfig(p.getEditor());
            this.editor = editor;
        }
        if (p.getAutocompletionSetting() != null) {
            this.autocompletionSetting = MetaAutocompletionSetting.createInstance(p.getAutocompletionSetting());
            this.autocompletionSetting.applyConfig(p.getAutocompletionSetting(), entity, null);
        }
        this.localizedDisplayLabelList = I18nUtil.toMeta(p.getLocalizedDisplayLabelList());
    }

    protected void fillCustomPropertyEditor(PropertyEditor pe, String propName, EntityContext context, EntityHandler entity) {
        if (pe instanceof JoinPropertyEditor) {
            ((JoinPropertyEditor)pe).setObjectName(entity.getMetaData().getName());
        } else if (pe instanceof DateRangePropertyEditor) {
            ((DateRangePropertyEditor)pe).setObjectName(entity.getMetaData().getName());
        } else if (pe instanceof NumericRangePropertyEditor) {
            ((NumericRangePropertyEditor)pe).setObjectName(entity.getMetaData().getName());
        } else if (pe instanceof ReferencePropertyEditor) {
            ReferencePropertyEditor rpe = (ReferencePropertyEditor)pe;
            PropertyHandler handler = this.getHandler(propName, context, entity);
            if (handler != null && handler instanceof ReferencePropertyHandler) {
                String objName = ((ReferencePropertyHandler)handler).getReferenceEntityHandler(context).getMetaData().getName();
                rpe.setObjectName(objName);
            }
            rpe.setReferenceFromObjectName(entity.getMetaData().getName());
        }
    }

    private PropertyHandler getHandler(String propName, EntityContext context, EntityHandler entity) {
        if (propName == null || propName.isEmpty()) {
            return null;
        }
        if (propName.contains(".")) {
            int indexOfDot = propName.indexOf(46);
            String objPropName = propName.substring(0, indexOfDot);
            String subPropPath = propName.substring(indexOfDot + 1, propName.length());
            PropertyHandler property = entity.getProperty(objPropName, context);
            if (!(property instanceof ReferencePropertyHandler)) {
                throw new IllegalArgumentException("path is invalid:" + objPropName + " is not ObjectReferenceProperty of " + entity.getMetaData().getName());
            }
            ReferencePropertyHandler refProp = (ReferencePropertyHandler)property;
            EntityHandler refEntity = refProp.getReferenceEntityHandler(context);
            if (refEntity == null) {
                throw new IllegalArgumentException(objPropName + "'s Entity is not defined.");
            }
            PropertyHandler refProperty = this.getHandler(subPropPath, context, refEntity);
            if (refProperty == null) {
                throw new IllegalArgumentException(subPropPath + "'s Property is not defined.");
            }
            return refProperty;
        }
        PropertyHandler property = entity.getProperty(propName, context);
        if (property == null) {
            throw new IllegalArgumentException(propName + "'s Property is not defined.");
        }
        return property;
    }

    @Override
    protected void fillTo(Element element, String definitionId) {
        EntityHandler entity;
        EntityContext metaContext = EntityContext.getCurrentContext();
        String name = this.convertName(this.propertyId, metaContext, entity = metaContext.getHandlerById(definitionId));
        if (name == null) {
            return;
        }
        PropertyBase p = (PropertyBase)element;
        super.fillTo(p, definitionId);
        p.setStyle(this.style);
        p.setPropertyName(name);
        p.setDisplayLabel(this.displayLabel);
        if (this.editor != null) {
            p.setEditor(this.editor.currentConfig(name));
        }
        if (this.autocompletionSetting != null) {
            p.setAutocompletionSetting(this.autocompletionSetting.currentConfig(entity, null));
        }
        p.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
    }

    @Override
    public ElementRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        MetaAutocompletionSetting.AutocompletionSettingRuntime runtime;
        if (this.autocompletionSetting != null && (runtime = this.autocompletionSetting.createRuntime(entityView)) != null) {
            entityView.addAutocompletionSetting(runtime);
        }
        return super.createRuntime(entityView, formView);
    }
}

