/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.property.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.element.property.validation.MetaRequiresAtLeastOneFieldValidator;
import org.iplass.mtp.view.generic.element.property.validation.RequiresAtLeastOneFieldValidator;
import org.iplass.mtp.view.generic.element.property.validation.ViewValidatorBase;

@XmlSeeAlso(value={MetaRequiresAtLeastOneFieldValidator.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class MetaViewValidator
implements MetaData {
    private static final long serialVersionUID = -3689861235173079692L;
    private String message;
    private List<MetaLocalizedString> localizedMessageList = new ArrayList<MetaLocalizedString>();
    private boolean validateNormal;
    private boolean validateDetail;

    public static MetaViewValidator createInstance(ViewValidatorBase validator) {
        if (validator instanceof RequiresAtLeastOneFieldValidator) {
            return MetaRequiresAtLeastOneFieldValidator.createInstance(validator);
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<MetaLocalizedString> getLocalizedMessageList() {
        return this.localizedMessageList;
    }

    public void setLocalizedMessageList(List<MetaLocalizedString> localizedMessageList) {
        this.localizedMessageList = localizedMessageList;
    }

    public boolean isValidateNormal() {
        return this.validateNormal;
    }

    public void setValidateNormal(boolean validateNormal) {
        this.validateNormal = validateNormal;
    }

    public boolean isValidateDetail() {
        return this.validateDetail;
    }

    public void setValidateDetail(boolean validateDetail) {
        this.validateDetail = validateDetail;
    }

    public void applyConfig(ViewValidatorBase validator, String definitionId) {
        this.message = validator.getMessage();
        this.localizedMessageList = I18nUtil.toMeta(validator.getLocalizedMessageList());
        this.validateNormal = validator.isValidateNormal();
        this.validateDetail = validator.isValidateDetail();
        this.fillFrom(validator, definitionId);
    }

    protected abstract void fillFrom(ViewValidatorBase var1, String var2);

    public ViewValidatorBase currentConfig(String definitionId) {
        ViewValidatorBase validator = this.fillTo(definitionId);
        validator.setMessage(this.message);
        validator.setLocalizedMessageList(I18nUtil.toDef(this.localizedMessageList));
        validator.setValidateNormal(this.validateNormal);
        validator.setValidateDetail(this.validateDetail);
        return validator;
    }

    protected abstract ViewValidatorBase fillTo(String var1);

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }
}

