/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.HasMetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaNestProperty;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.ElementRuntime;
import org.iplass.mtp.impl.view.generic.element.MetaButton;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.impl.view.generic.element.MetaLink;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyItem;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyLayout;
import org.iplass.mtp.impl.view.generic.element.section.MetaMassReferenceSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaReferenceSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.property.PropertyBase;
import org.iplass.mtp.view.generic.element.property.PropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.MassReferenceSection;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;
import org.iplass.mtp.view.generic.element.section.Section;

public class MetaDefaultSection
extends MetaSection {
    private static final long serialVersionUID = 6368546528151431462L;
    @Deprecated
    private static boolean defaultDispBorderInSection;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean expandable;
    private String id;
    private String style;
    private int colNum;
    private boolean showLink;
    private boolean hideDetail;
    private boolean hideView;
    private String upperContents;
    private String lowerContents;
    private boolean dispBorderInSection = defaultDispBorderInSection;
    private List<MetaElement> elements;
    private String styleScriptKey;
    private String contentScriptKey;

    public static MetaDefaultSection createInstance(Element element) {
        return new MetaDefaultSection();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public String getUpperContents() {
        return this.upperContents;
    }

    public void setUpperContents(String upperContents) {
        this.upperContents = upperContents;
    }

    public String getLowerContents() {
        return this.lowerContents;
    }

    public void setLowerContents(String lowerContents) {
        this.lowerContents = lowerContents;
    }

    public boolean isDispBorderInSection() {
        return this.dispBorderInSection;
    }

    public void setDispBorderInSection(boolean dispBorderInSection) {
        this.dispBorderInSection = dispBorderInSection;
    }

    public List<MetaElement> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<MetaElement>();
        }
        return this.elements;
    }

    public void setElements(List<MetaElement> elements) {
        this.elements = elements;
    }

    public void addElement(MetaElement element) {
        if (this.elements == null) {
            this.elements = new ArrayList<MetaElement>();
        }
        this.elements.add(element);
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public MetaDefaultSection copy() {
        return (MetaDefaultSection)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        DefaultSection section = (DefaultSection)element;
        this.title = section.getTitle();
        this.expandable = section.isExpandable();
        this.id = section.getId();
        this.style = section.getStyle();
        this.colNum = section.getColNum();
        this.showLink = section.isShowLink();
        this.hideDetail = section.isHideDetail();
        this.hideView = section.isHideView();
        this.upperContents = section.getUpperContents();
        this.lowerContents = section.getLowerContents();
        this.dispBorderInSection = section.isDispBorderInSection();
        if (section.getElements().size() > 0) {
            for (Element elem : section.getElements()) {
                MetaElement mElem = null;
                mElem = elem instanceof Section ? this.fillFromSection(elem, definitionId) : (elem instanceof PropertyItem ? this.fillFromProperty(elem, definitionId) : this.fillFromElement(elem, definitionId));
                if (mElem == null) continue;
                this.addElement(mElem);
            }
        }
        this.localizedTitleList = I18nUtil.toMeta(section.getLocalizedTitleList());
    }

    private MetaElement fillFromElement(Element element, String definitionId) {
        MetaElement mElem = MetaElement.createInstance(element);
        mElem.applyConfig(element, definitionId);
        return mElem;
    }

    private MetaPropertyLayout fillFromProperty(Element element, String definitionId) {
        MetaPropertyItem mProp = new MetaPropertyItem();
        mProp.applyConfig(element, definitionId);
        if (mProp.getPropertyId() == null) {
            mProp = null;
        }
        return mProp;
    }

    private MetaSection fillFromSection(Element element, String definitionId) {
        MetaMassReferenceSection ms;
        MetaReferenceSection rs;
        MetaSection meta = MetaSection.createInstance(element);
        meta.applyConfig(element, definitionId);
        if (element instanceof ReferenceSection ? (rs = (MetaReferenceSection)meta).getPropertyId() == null : element instanceof MassReferenceSection && (ms = (MetaMassReferenceSection)meta).getPropertyId() == null) {
            return null;
        }
        return meta;
    }

    @Override
    public Element currentConfig(String definitionId) {
        DefaultSection section = new DefaultSection();
        super.fillTo(section, definitionId);
        section.setStyleScriptKey(this.styleScriptKey);
        section.setContentScriptKey(this.contentScriptKey);
        section.setExpandable(this.expandable);
        section.setTitle(this.title);
        section.setId(this.id);
        section.setStyle(this.style);
        section.setColNum(this.colNum);
        section.setShowLink(this.showLink);
        section.setHideDetail(this.hideDetail);
        section.setHideView(this.hideView);
        section.setUpperContents(this.upperContents);
        section.setLowerContents(this.lowerContents);
        section.setDispBorderInSection(this.dispBorderInSection);
        if (this.getElements().size() > 0) {
            for (MetaElement elem : this.getElements()) {
                if (elem instanceof MetaSection) {
                    Section subSection = this.fillToSection(elem, definitionId);
                    if (subSection == null) continue;
                    section.addElement(subSection);
                    continue;
                }
                if (elem instanceof MetaPropertyLayout) {
                    PropertyBase p = this.fillToProperty(elem, definitionId);
                    if (p == null) continue;
                    section.addElement(p);
                    continue;
                }
                Element e = this.fillToElement(elem, definitionId);
                if (e == null) continue;
                section.addElement(e);
            }
        }
        section.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return section;
    }

    private Element fillToElement(MetaElement element, String definitionId) {
        Element elem = element.currentConfig(definitionId);
        return elem;
    }

    private PropertyBase fillToProperty(MetaElement element, String definitionId) {
        MetaPropertyLayout mp = (MetaPropertyLayout)element;
        PropertyItem property = (PropertyItem)mp.currentConfig(definitionId);
        return property;
    }

    private Section fillToSection(MetaElement element, String definitionId) {
        MetaSection ms = (MetaSection)element;
        Section section = (Section)ms.currentConfig(definitionId);
        return section;
    }

    @Override
    public DefaultSectionRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new DefaultSectionRuntime(this, entityView, formView);
    }

    static {
        String value = System.getProperty("mtp.generic.dispBorderInSection", "true");
        defaultDispBorderInSection = Boolean.parseBoolean(value);
    }

    public class DefaultSectionRuntime
    extends SectionRuntime {
        private List<ElementRuntime> elements;

        public DefaultSectionRuntime(MetaDefaultSection metadata, EntityViewRuntime entityView, FormViewRuntime formView) {
            super(metadata, entityView);
            EntityContext context = EntityContext.getCurrentContext();
            EntityHandler eh = context.getHandlerById(entityView.getMetaData().getDefinitionId());
            this.elements = new ArrayList<ElementRuntime>();
            HashMap<String, GroovyTemplate> customStyleMap = new HashMap<String, GroovyTemplate>();
            for (MetaElement element : metadata.getElements()) {
                ElementRuntime runtime;
                MetaPropertyLayout propertyLayout;
                MetaPropertyEditor editor;
                this.elements.add(element.createRuntime(entityView, formView));
                if (element instanceof MetaPropertyLayout && (editor = (propertyLayout = (MetaPropertyLayout)element).getEditor()) != null) {
                    MetaPropertyEditor.PropertyEditorRuntime runtime2 = (MetaPropertyEditor.PropertyEditorRuntime)editor.createRuntime(entityView, formView, propertyLayout, context, eh);
                    customStyleMap.put(editor.getOutputCustomStyleScriptKey(), runtime2.getOutputCustomStyleScript());
                    customStyleMap.put(editor.getInputCustomStyleScriptKey(), runtime2.getInputCustomStyleScript());
                    if (editor instanceof HasMetaNestProperty) {
                        for (MetaNestProperty nest : ((HasMetaNestProperty)((Object)editor)).getNestProperties()) {
                            MetaPropertyEditor nestEditor = nest.getEditor();
                            if (nestEditor == null) continue;
                            MetaPropertyEditor.PropertyEditorRuntime nestRuntime = (MetaPropertyEditor.PropertyEditorRuntime)nestEditor.createRuntime(entityView, formView, null, context, eh);
                            customStyleMap.put(nestEditor.getOutputCustomStyleScriptKey(), nestRuntime.getOutputCustomStyleScript());
                            customStyleMap.put(nestEditor.getInputCustomStyleScriptKey(), nestRuntime.getInputCustomStyleScript());
                        }
                    }
                }
                if (element instanceof MetaButton) {
                    MetaButton button = (MetaButton)element;
                    runtime = button.createRuntime(entityView, formView);
                    customStyleMap.put(button.getInputCustomStyleScriptKey(), ((MetaButton.ButtonRuntime)runtime).getInputCustomStyleScript());
                }
                if (!(element instanceof MetaLink)) continue;
                MetaLink link = (MetaLink)element;
                runtime = link.createRuntime(entityView, formView);
                customStyleMap.put(link.getInputCustomStyleScriptKey(), ((MetaLink.LinkRuntime)runtime).getInputCustomStyleScript());
            }
            metadata.styleScriptKey = "DefaultSection_Style_" + GroovyTemplateCompiler.randomName().replace("-", "_");
            entityView.addCustomStyle(MetaDefaultSection.this.styleScriptKey, customStyleMap);
            if (StringUtil.isNotEmpty((String)metadata.upperContents) || StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                if (metadata.contentScriptKey == null) {
                    metadata.contentScriptKey = "DefaultSection_content_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                }
                if (StringUtil.isNotEmpty((String)metadata.upperContents)) {
                    String upperKey = metadata.contentScriptKey + "_UpperContent";
                    entityView.addTemplate(upperKey, this.compile(metadata.upperContents, upperKey));
                }
                if (StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                    String lowerKey = metadata.contentScriptKey + "_LowerContent";
                    entityView.addTemplate(lowerKey, this.compile(metadata.lowerContents, lowerKey));
                }
            }
        }

        private GroovyTemplate compile(String script, String key) {
            TenantContext tenant = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)script, (String)key, (GroovyScriptEngine)((GroovyScriptEngine)tenant.getScriptEngine()));
        }
    }
}

