/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaNestProperty;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaSortSetting;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.PagingPosition;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.MassReferenceSection;
import org.iplass.mtp.view.generic.element.section.SortSetting;

public class MetaMassReferenceSection
extends MetaSection {
    private static final long serialVersionUID = -2758207829852210618L;
    private String propertyId;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean expandable;
    private String id;
    private String style;
    private boolean showLink;
    private String upperContents;
    private String lowerContents;
    private int limit;
    private String viewActionName;
    private String detailActionName;
    private String viewTabActionName;
    private String detailTabActionName;
    private String viewName;
    private List<String> withoutConditionReferenceName;
    private boolean changeEditLinkToViewLink;
    private boolean hideDeleteButton;
    private boolean hideAddButton;
    private boolean hidePaging;
    private boolean hideCount;
    private boolean hidePageJump;
    private boolean hidePageLink;
    private boolean showSearchBtn;
    private PagingPosition pagingPosition;
    private boolean hideDetail;
    private boolean hideView;
    private MassReferenceSection.MassReferenceEditType editType;
    private List<MetaNestProperty> nestProperties;
    private List<MetaSortSetting> sortSetting;
    private String filterConditionScript;
    private String contentScriptKey;

    public static MetaMassReferenceSection createInstance(Element element) {
        return new MetaMassReferenceSection();
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public String getUpperContents() {
        return this.upperContents;
    }

    public void setUpperContents(String upperContents) {
        this.upperContents = upperContents;
    }

    public String getLowerContents() {
        return this.lowerContents;
    }

    public void setLowerContents(String lowerContents) {
        this.lowerContents = lowerContents;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getViewActionName() {
        return this.viewActionName;
    }

    public void setViewActionName(String viewActionName) {
        this.viewActionName = viewActionName;
    }

    public String getDetailActionName() {
        return this.detailActionName;
    }

    public void setDetailActionName(String detailActionName) {
        this.detailActionName = detailActionName;
    }

    public String getViewTabActionName() {
        return this.viewTabActionName;
    }

    public void setViewTabActionName(String viewTabActionName) {
        this.viewTabActionName = viewTabActionName;
    }

    public String getDetailTabActionName() {
        return this.detailTabActionName;
    }

    public void setDetailTabActionName(String detailTabActionName) {
        this.detailTabActionName = detailTabActionName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public List<String> getWithoutConditionReferenceName() {
        return this.withoutConditionReferenceName;
    }

    public void setWithoutConditionReferenceName(List<String> withoutConditionReferenceName) {
        this.withoutConditionReferenceName = withoutConditionReferenceName;
    }

    public boolean isChangeEditLinkToViewLink() {
        return this.changeEditLinkToViewLink;
    }

    public void setChangeEditLinkToViewLink(boolean changeEditLinkToViewLink) {
        this.changeEditLinkToViewLink = changeEditLinkToViewLink;
    }

    public boolean isHideDeleteButton() {
        return this.hideDeleteButton;
    }

    public void setHideDeleteButton(boolean hideDeleteButton) {
        this.hideDeleteButton = hideDeleteButton;
    }

    public boolean isHideAddButton() {
        return this.hideAddButton;
    }

    public void setHideAddButton(boolean hideAddButton) {
        this.hideAddButton = hideAddButton;
    }

    public boolean isHidePaging() {
        return this.hidePaging;
    }

    public void setHidePaging(boolean hidePaging) {
        this.hidePaging = hidePaging;
    }

    public boolean isHideCount() {
        return this.hideCount;
    }

    public void setHideCount(boolean hideCount) {
        this.hideCount = hideCount;
    }

    public boolean isHidePageJump() {
        return this.hidePageJump;
    }

    public void setHidePageJump(boolean hidePageJump) {
        this.hidePageJump = hidePageJump;
    }

    public boolean isHidePageLink() {
        return this.hidePageLink;
    }

    public void setHidePageLink(boolean hidePageLink) {
        this.hidePageLink = hidePageLink;
    }

    public boolean isShowSearchBtn() {
        return this.showSearchBtn;
    }

    public void setShowSearchBtn(boolean showSearchBtn) {
        this.showSearchBtn = showSearchBtn;
    }

    public PagingPosition getPagingPosition() {
        return this.pagingPosition;
    }

    public void setPagingPosition(PagingPosition pagingPosition) {
        this.pagingPosition = pagingPosition;
    }

    public MassReferenceSection.MassReferenceEditType getEditType() {
        return this.editType;
    }

    public void setEditType(MassReferenceSection.MassReferenceEditType editType) {
        this.editType = editType;
    }

    public List<MetaNestProperty> getNestProperties() {
        if (this.nestProperties == null) {
            this.nestProperties = new ArrayList<MetaNestProperty>();
        }
        return this.nestProperties;
    }

    public void setNestProperties(List<MetaNestProperty> nestProperties) {
        this.nestProperties = nestProperties;
    }

    public List<MetaSortSetting> getSortSetting() {
        if (this.sortSetting == null) {
            this.sortSetting = new ArrayList<MetaSortSetting>();
        }
        return this.sortSetting;
    }

    public void setSortSetting(List<MetaSortSetting> sortSetting) {
        this.sortSetting = sortSetting;
    }

    public void addSortSetting(MetaSortSetting setting) {
        this.getSortSetting().add(setting);
    }

    public String getFilterConditionScript() {
        return this.filterConditionScript;
    }

    public void setFilterConditionScript(String filterConditionScript) {
        this.filterConditionScript = filterConditionScript;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public void addNestProperty(MetaNestProperty property) {
        this.getNestProperties().add(property);
    }

    public MetaMassReferenceSection copy() {
        return (MetaMassReferenceSection)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        MassReferenceSection section = (MassReferenceSection)element;
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler entity = ctx.getHandlerById(definitionId);
        if (entity == null) {
            return;
        }
        PropertyHandler property = entity.getProperty(section.getPropertyName(), ctx);
        if (!(property instanceof ReferencePropertyHandler)) {
            throw new EntityRuntimeException(section.getPropertyName() + " is not ReferenceProperty.");
        }
        ReferencePropertyHandler rp = (ReferencePropertyHandler)property;
        ReferencePropertyHandler mappedBy = rp.getMappedByPropertyHandler(ctx);
        if (mappedBy == null) {
            throw new EntityRuntimeException(section.getPropertyName() + " is not MappedByProperty. MassReferencePropertyEditor is supports only MappedByProperty.");
        }
        EntityHandler refEntity = mappedBy.getParent();
        this.propertyId = property.getId();
        this.title = section.getTitle();
        this.expandable = section.isExpandable();
        this.id = section.getId();
        this.style = section.getStyle();
        this.showLink = section.isShowLink();
        this.upperContents = section.getUpperContents();
        this.lowerContents = section.getLowerContents();
        this.limit = section.getLimit();
        this.viewActionName = section.getViewActionName();
        this.viewTabActionName = section.getViewTabActionName();
        this.detailActionName = section.getDetailActionName();
        this.detailTabActionName = section.getDetailTabActionName();
        this.viewName = section.getViewName();
        this.withoutConditionReferenceName = section.getWithoutConditionReferenceName() == null ? null : new ArrayList<String>(section.getWithoutConditionReferenceName());
        this.changeEditLinkToViewLink = section.isChangeEditLinkToViewLink();
        this.hideDeleteButton = section.isHideDeleteButton();
        this.hideAddButton = section.isHideAddButton();
        this.hidePaging = section.isHidePaging();
        this.hidePageJump = section.isHidePageJump();
        this.hidePageLink = section.isHidePageLink();
        this.showSearchBtn = section.isShowSearchBtn();
        this.pagingPosition = section.getPagingPosition();
        this.hideCount = section.isHideCount();
        this.hideDetail = section.isHideDetail();
        this.hideView = section.isHideView();
        this.editType = section.getEditType();
        this.filterConditionScript = section.getFilterConditionScript();
        for (NestProperty np : section.getProperties()) {
            MetaNestProperty mnp = new MetaNestProperty();
            mnp.applyConfig(np, refEntity, entity);
            if (mnp.getPropertyId() == null) continue;
            this.addNestProperty(mnp);
        }
        if (!section.getSortSetting().isEmpty()) {
            for (SortSetting setting : section.getSortSetting()) {
                MetaSortSetting meta = new MetaSortSetting();
                meta.applyConfig(setting, ctx, refEntity);
                this.addSortSetting(meta);
            }
        }
        this.localizedTitleList = I18nUtil.toMeta(section.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        ReferencePropertyHandler mappedBy;
        MassReferenceSection section = new MassReferenceSection();
        super.fillTo(section, definitionId);
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler entity = ctx.getHandlerById(definitionId);
        if (entity == null) {
            return null;
        }
        PropertyHandler property = entity.getPropertyById(this.propertyId, ctx);
        if (property == null || !(property instanceof ReferencePropertyHandler)) {
            return null;
        }
        ReferencePropertyHandler rp = (ReferencePropertyHandler)property;
        EntityHandler refEntity = null;
        if (rp != null && (mappedBy = rp.getMappedByPropertyHandler(ctx)) != null) {
            refEntity = mappedBy.getParent();
        }
        if (refEntity == null) {
            return null;
        }
        section.setDefintionName(refEntity.getMetaData().getName());
        section.setPropertyName(rp.getName());
        section.setTitle(this.title);
        section.setExpandable(this.expandable);
        section.setId(this.id);
        section.setStyle(this.style);
        section.setShowLink(this.showLink);
        section.setUpperContents(this.upperContents);
        section.setLowerContents(this.lowerContents);
        section.setLimit(this.limit);
        section.setViewActionName(this.viewActionName);
        section.setViewTabActionName(this.viewTabActionName);
        section.setDetailActionName(this.detailActionName);
        section.setDetailTabActionName(this.detailTabActionName);
        section.setViewName(this.viewName);
        section.setWithoutConditionReferenceName((List<String>)(this.withoutConditionReferenceName == null ? null : new ArrayList<String>(this.withoutConditionReferenceName)));
        section.setChangeEditLinkToViewLink(this.changeEditLinkToViewLink);
        section.setHideDeleteButton(this.hideDeleteButton);
        section.setHideAddButton(this.hideAddButton);
        section.setHidePaging(this.hidePaging);
        section.setHidePageJump(this.hidePageJump);
        section.setHidePageLink(this.hidePageLink);
        section.setShowSearchBtn(this.showSearchBtn);
        section.setPagingPosition(this.pagingPosition);
        section.setHideCount(this.hideCount);
        section.setHideDetail(this.hideDetail);
        section.setHideView(this.hideView);
        section.setEditType(this.editType);
        section.setFilterConditionScript(this.filterConditionScript);
        section.setContentScriptKey(this.contentScriptKey);
        for (MetaNestProperty mnp : this.getNestProperties()) {
            NestProperty np;
            if (refEntity == null || (np = mnp.currentConfig(refEntity, entity)) == null) continue;
            section.addProperty(np);
        }
        if (!this.getSortSetting().isEmpty()) {
            for (MetaSortSetting meta : this.getSortSetting()) {
                SortSetting ss = meta.currentConfig(ctx, refEntity);
                if (ss == null) continue;
                section.addSortSetting(ss);
            }
        }
        section.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return section;
    }

    @Override
    public SectionRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new MassReferenceSectionRuntime(this, entityView);
    }

    public class MassReferenceSectionRuntime
    extends SectionRuntime {
        public static final String FILTER_CONDITION_PREFIX = "MassReferenceSection_filterCondition_";

        public MassReferenceSectionRuntime(MetaMassReferenceSection metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            if (StringUtil.isNotBlank((String)metadata.filterConditionScript)) {
                PreparedQuery query = new PreparedQuery(metadata.filterConditionScript);
                entityView.addQuery(FILTER_CONDITION_PREFIX + metadata.getElementRuntimeId(), query);
            }
            if (MetaMassReferenceSection.this.nestProperties != null && !MetaMassReferenceSection.this.nestProperties.isEmpty()) {
                for (MetaNestProperty meta : MetaMassReferenceSection.this.nestProperties) {
                    if (meta.getAutocompletionSetting() == null) continue;
                    entityView.addAutocompletionSetting(meta.getAutocompletionSetting().createRuntime(entityView));
                }
            }
            if (StringUtil.isNotEmpty((String)metadata.upperContents) || StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                if (metadata.contentScriptKey == null) {
                    metadata.contentScriptKey = "MassReferenceSection_content_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                }
                if (StringUtil.isNotEmpty((String)metadata.upperContents)) {
                    String upperKey = metadata.contentScriptKey + "_UpperContent";
                    entityView.addTemplate(upperKey, this.compile(metadata.upperContents, upperKey));
                }
                if (StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                    String lowerKey = metadata.contentScriptKey + "_LowerContent";
                    entityView.addTemplate(lowerKey, this.compile(metadata.lowerContents, lowerKey));
                }
            }
        }

        @Override
        public MetaMassReferenceSection getMetaData() {
            return (MetaMassReferenceSection)super.getMetaData();
        }

        private GroovyTemplate compile(String script, String key) {
            TenantContext tenant = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)script, (String)key, (GroovyScriptEngine)((GroovyScriptEngine)tenant.getScriptEngine()));
        }
    }
}

