/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaNestProperty;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;

public class MetaReferenceSection
extends MetaSection {
    private static final long serialVersionUID = -3690001980373138857L;
    @Deprecated
    private static boolean defaultDispBorderInSection;
    private String propertyId;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean expandable;
    private String id;
    private String style;
    private int colNum;
    private boolean showLink;
    private boolean hideDetail;
    private boolean hideView;
    private boolean forceUpadte;
    private String upperContents;
    private String lowerContents;
    private List<MetaNestProperty> properties;
    private String orderPropId;
    private int index;
    private boolean dispBorderInSection = defaultDispBorderInSection;
    private String contentScriptKey;

    public static MetaReferenceSection createInstance(Element element) {
        return new MetaReferenceSection();
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isExpandable() {
        return this.expandable;
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public boolean isForceUpadte() {
        return this.forceUpadte;
    }

    public void setForceUpadte(boolean forceUpadte) {
        this.forceUpadte = forceUpadte;
    }

    public String getUpperContents() {
        return this.upperContents;
    }

    public void setUpperContents(String upperContents) {
        this.upperContents = upperContents;
    }

    public String getLowerContents() {
        return this.lowerContents;
    }

    public void setLowerContents(String lowerContents) {
        this.lowerContents = lowerContents;
    }

    public List<MetaNestProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<MetaNestProperty>();
        }
        return this.properties;
    }

    public void setProperties(List<MetaNestProperty> properties) {
        this.properties = properties;
    }

    public String getOrderPropName() {
        return this.orderPropId;
    }

    public void setOrderPropName(String orderPropName) {
        this.orderPropId = orderPropName;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isDispBorderInSection() {
        return this.dispBorderInSection;
    }

    public void setDispBorderInSection(boolean dispBorderInSection) {
        this.dispBorderInSection = dispBorderInSection;
    }

    public void addProperty(MetaNestProperty property) {
        this.getProperties().add(property);
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        PropertyHandler orderProp;
        super.fillFrom(element, definitionId);
        ReferenceSection section = (ReferenceSection)element;
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler entity = ctx.getHandlerById(definitionId);
        if (entity == null) {
            return;
        }
        PropertyHandler property = entity.getProperty(section.getPropertyName(), ctx);
        if (!(property instanceof ReferencePropertyHandler)) {
            return;
        }
        ReferencePropertyHandler refHandler = (ReferencePropertyHandler)property;
        EntityHandler refEntity = refHandler.getReferenceEntityHandler(ctx);
        this.propertyId = refHandler.getId();
        this.title = section.getTitle();
        this.expandable = section.isExpandable();
        this.id = section.getId();
        this.style = section.getStyle();
        this.colNum = section.getColNum();
        this.showLink = section.isShowLink();
        this.hideDetail = section.isHideDetail();
        this.hideView = section.isHideView();
        this.forceUpadte = section.isForceUpadte();
        this.upperContents = section.getUpperContents();
        this.lowerContents = section.getLowerContents();
        this.index = section.getIndex();
        this.dispBorderInSection = section.isDispBorderInSection();
        if (StringUtil.isNotBlank((String)section.getOrderPropName()) && (orderProp = refEntity.getProperty(section.getOrderPropName(), ctx)) != null) {
            this.orderPropId = orderProp.getId();
        }
        for (NestProperty nest : section.getProperties()) {
            MetaNestProperty meta = new MetaNestProperty();
            meta.applyConfig(nest, refEntity, entity);
            if (meta.getPropertyId() == null) continue;
            this.addProperty(meta);
        }
        this.localizedTitleList = I18nUtil.toMeta(section.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        PropertyHandler orderProp;
        ReferenceSection section = new ReferenceSection();
        super.fillTo(section, definitionId);
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler entity = ctx.getHandlerById(definitionId);
        if (entity == null) {
            return null;
        }
        PropertyHandler property = entity.getPropertyById(this.propertyId, ctx);
        if (property == null || !(property instanceof ReferencePropertyHandler)) {
            return null;
        }
        ReferencePropertyHandler refHandler = (ReferencePropertyHandler)property;
        EntityHandler refEntity = refHandler.getReferenceEntityHandler(ctx);
        if (refEntity == null) {
            return null;
        }
        section.setDefintionName(refEntity.getMetaData().getName());
        section.setPropertyName(refHandler.getName());
        section.setTitle(this.title);
        section.setExpandable(this.expandable);
        section.setId(this.id);
        section.setStyle(this.style);
        section.setColNum(this.colNum);
        section.setShowLink(this.showLink);
        section.setHideDetail(this.hideDetail);
        section.setHideView(this.hideView);
        section.setForceUpadte(this.forceUpadte);
        section.setUpperContents(this.upperContents);
        section.setLowerContents(this.lowerContents);
        section.setIndex(this.index);
        section.setDispBorderInSection(this.dispBorderInSection);
        if (StringUtil.isNotBlank((String)this.orderPropId) && (orderProp = refEntity.getPropertyById(this.orderPropId, ctx)) != null) {
            section.setOrderPropName(orderProp.getName());
        }
        for (MetaNestProperty meta : this.getProperties()) {
            NestProperty nest = meta.currentConfig(refEntity, entity);
            if (nest == null) continue;
            section.addProperty(nest);
        }
        section.setContentScriptKey(this.contentScriptKey);
        section.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return section;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    @Override
    public SectionRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new ReferenceSectionRuntime(this, entityView);
    }

    static {
        String value = System.getProperty("mtp.generic.dispBorderInSection", "true");
        defaultDispBorderInSection = Boolean.parseBoolean(value);
    }

    public class ReferenceSectionRuntime
    extends SectionRuntime {
        public ReferenceSectionRuntime(MetaReferenceSection metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            if (MetaReferenceSection.this.properties != null && !MetaReferenceSection.this.properties.isEmpty()) {
                for (MetaNestProperty meta : MetaReferenceSection.this.properties) {
                    if (meta.getAutocompletionSetting() == null) continue;
                    entityView.addAutocompletionSetting(meta.getAutocompletionSetting().createRuntime(entityView));
                }
            }
            if (StringUtil.isNotEmpty((String)metadata.upperContents) || StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                if (metadata.contentScriptKey == null) {
                    metadata.contentScriptKey = "ReferenceSection_content_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                }
                if (StringUtil.isNotEmpty((String)metadata.upperContents)) {
                    String upperKey = metadata.contentScriptKey + "_UpperContent";
                    entityView.addTemplate(upperKey, this.compile(metadata.upperContents, upperKey));
                }
                if (StringUtil.isNotEmpty((String)metadata.lowerContents)) {
                    String lowerKey = metadata.contentScriptKey + "_LowerContent";
                    entityView.addTemplate(lowerKey, this.compile(metadata.lowerContents, lowerKey));
                }
            }
        }

        @Override
        public MetaReferenceSection getMetaData() {
            return (MetaReferenceSection)super.getMetaData();
        }

        private GroovyTemplate compile(String script, String key) {
            TenantContext tenant = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)script, (String)key, (GroovyScriptEngine)((GroovyScriptEngine)tenant.getScriptEngine()));
        }
    }
}

