/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.ScriptingSection;

public class MetaScriptingSection
extends MetaSection {
    private static final long serialVersionUID = -8540919663557511912L;
    private String script;
    private String title;
    private String id;
    private boolean showLink;
    private boolean hideDetail;
    private boolean hideView;
    private String key;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean dispBorderInSection;

    public static MetaScriptingSection createInstance(Element element) {
        return new MetaScriptingSection();
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public boolean isDispBorderInSection() {
        return this.dispBorderInSection;
    }

    public void setDispBorderInSection(boolean dispBorderInSection) {
        this.dispBorderInSection = dispBorderInSection;
    }

    public MetaScriptingSection copy() {
        return (MetaScriptingSection)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        ScriptingSection script = (ScriptingSection)element;
        this.script = script.getScript();
        this.title = script.getTitle();
        this.id = script.getId();
        this.showLink = script.isShowLink();
        this.hideDetail = script.isHideDetail();
        this.hideView = script.isHideView();
        this.dispBorderInSection = script.isDispBorderInSection();
        this.localizedTitleList = I18nUtil.toMeta(script.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        ScriptingSection script = new ScriptingSection();
        super.fillTo(script, definitionId);
        script.setScript(this.script);
        script.setKey(this.key);
        script.setTitle(this.title);
        script.setId(this.id);
        script.setShowLink(this.showLink);
        script.setHideDetail(this.hideDetail);
        script.setHideView(this.hideView);
        script.setDispBorderInSection(this.dispBorderInSection);
        script.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return script;
    }

    @Override
    public ScriptingSectionRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new ScriptingSectionRuntime(this, entityView);
    }

    public class ScriptingSectionRuntime
    extends SectionRuntime {
        public ScriptingSectionRuntime(MetaScriptingSection metadata, EntityViewRuntime entityView) {
            super(metadata, entityView);
            if (metadata.script != null && metadata.key == null) {
                metadata.key = "Jsp_" + GroovyTemplateCompiler.randomName().replace("-", "_");
                entityView.addTemplate(MetaScriptingSection.this.key, this.compile(MetaScriptingSection.this.key));
            }
        }

        private GroovyTemplate compile(String key) {
            TenantContext tenant = ExecuteContext.getCurrentContext().getTenantContext();
            return GroovyTemplateCompiler.compile((String)this.getMetaData().script, (String)key, (GroovyScriptEngine)((GroovyScriptEngine)tenant.getScriptEngine()));
        }

        @Override
        public MetaScriptingSection getMetaData() {
            return (MetaScriptingSection)super.getMetaData();
        }
    }
}

