/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.mtp.entity.csv.MultipleFormat;
import org.iplass.mtp.entity.query.PreparedQuery;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.EntityViewRuntime;
import org.iplass.mtp.impl.view.generic.FormViewRuntime;
import org.iplass.mtp.impl.view.generic.editor.MetaPropertyEditor;
import org.iplass.mtp.impl.view.generic.element.MetaElement;
import org.iplass.mtp.impl.view.generic.element.property.MetaPropertyItem;
import org.iplass.mtp.impl.view.generic.element.section.MetaFilterSetting;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.impl.view.generic.element.section.MetaSortSetting;
import org.iplass.mtp.impl.view.generic.element.section.SectionRuntime;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.FilterSetting;
import org.iplass.mtp.view.generic.element.section.SearchConditionSection;
import org.iplass.mtp.view.generic.element.section.SortSetting;

public class MetaSearchConditionSection
extends MetaSection {
    private static final long serialVersionUID = -9083146736532796083L;
    private int conditionDispCount;
    private int colNum;
    private boolean unsorted;
    private boolean fulltextSearchSorted;
    private boolean distinct;
    private boolean hideDetailCondition;
    private boolean hideFixedCondition;
    private boolean hideCsvUpload;
    private boolean csvUploadDenyInsert;
    private boolean csvUploadDenyUpdate;
    private boolean csvUploadDenyDelete;
    private String csvUploadInsertProperties;
    private String csvUploadUpdateProperties;
    private SearchConditionSection.CsvUploadTransactionType csvUploadTransactionType = SearchConditionSection.CsvUploadTransactionType.ONCE;
    private boolean hideCsvdownload;
    private boolean hideCsvdownloadDialog;
    private SearchConditionSection.CsvDownloadSpecifyCharacterCode specifyCharacterCode = SearchConditionSection.CsvDownloadSpecifyCharacterCode.NONE;
    private boolean nonOutputOid;
    private boolean nonOutputReference;
    private boolean nonOutputBinaryRef;
    private Integer csvdownloadMaxCount;
    private boolean uploadableCsvdownloadLoadAtOnce;
    private Integer uploadableCsvdownloadLoadSize;
    private String csvdownloadProperties;
    private String csvdownloadUploadableProperties;
    private String csvdownloadFileNameFormat;
    private MultipleFormat csvMultipleFormat = MultipleFormat.EACH_COLUMN;
    private String defaultCondition;
    private boolean useDefaultConditionWithFilterDefinition;
    private String defaultPropertyConditionScript;
    private List<MetaSortSetting> sortSetting;
    private List<MetaFilterSetting> filterSetting;
    private List<MetaElement> elements;
    private String scriptKey;

    public static MetaSearchConditionSection createInstance(Element element) {
        return new MetaSearchConditionSection();
    }

    public Integer getCsvdownloadMaxCount() {
        return this.csvdownloadMaxCount;
    }

    public void setCsvdownloadMaxCount(Integer csvdownloadMaxCount) {
        this.csvdownloadMaxCount = csvdownloadMaxCount;
    }

    public boolean isUploadableCsvdownloadLoadAtOnce() {
        return this.uploadableCsvdownloadLoadAtOnce;
    }

    public void setUploadableCsvdownloadLoadAtOnce(boolean uploadableCsvdownloadLoadAtOnce) {
        this.uploadableCsvdownloadLoadAtOnce = uploadableCsvdownloadLoadAtOnce;
    }

    public Integer getUploadableCsvdownloadLoadSize() {
        return this.uploadableCsvdownloadLoadSize;
    }

    public void setUploadableCsvdownloadLoadSize(Integer uploadableCsvdownloadLoadSize) {
        this.uploadableCsvdownloadLoadSize = uploadableCsvdownloadLoadSize;
    }

    public boolean isHideCsvdownloadDialog() {
        return this.hideCsvdownloadDialog;
    }

    public void setHideCsvdownloadDialog(boolean hideCsvdownloadDialog) {
        this.hideCsvdownloadDialog = hideCsvdownloadDialog;
    }

    public SearchConditionSection.CsvDownloadSpecifyCharacterCode isSpecifyCharacterCode() {
        return this.specifyCharacterCode;
    }

    public void setSpecifyCharacterCode(SearchConditionSection.CsvDownloadSpecifyCharacterCode specifyCharacterCode) {
        this.specifyCharacterCode = specifyCharacterCode;
    }

    public SearchConditionSection.CsvUploadTransactionType getCsvUploadTransactionType() {
        return this.csvUploadTransactionType;
    }

    public void setCsvUploadTransactionType(SearchConditionSection.CsvUploadTransactionType csvUploadTransactionType) {
        this.csvUploadTransactionType = csvUploadTransactionType;
    }

    public boolean isHideCsvUpload() {
        return this.hideCsvUpload;
    }

    public void setHideCsvUpload(boolean hideCsvUpload) {
        this.hideCsvUpload = hideCsvUpload;
    }

    public boolean isCsvUploadDenyInsert() {
        return this.csvUploadDenyInsert;
    }

    public void setCsvUploadDenyInsert(boolean csvUploadDenyInsert) {
        this.csvUploadDenyInsert = csvUploadDenyInsert;
    }

    public boolean isCsvUploadDenyUpdate() {
        return this.csvUploadDenyUpdate;
    }

    public void setCsvUploadDenyUpdate(boolean csvUploadDenyUpdate) {
        this.csvUploadDenyUpdate = csvUploadDenyUpdate;
    }

    public boolean isCsvUploadDenyDelete() {
        return this.csvUploadDenyDelete;
    }

    public void setCsvUploadDenyDelete(boolean csvUploadDenyDelete) {
        this.csvUploadDenyDelete = csvUploadDenyDelete;
    }

    public String getCsvUploadInsertProperties() {
        return this.csvUploadInsertProperties;
    }

    public void setCsvUploadInsertProperties(String csvUploadInsertProperties) {
        this.csvUploadInsertProperties = csvUploadInsertProperties;
    }

    public String getCsvUploadUpdateProperties() {
        return this.csvUploadUpdateProperties;
    }

    public void setCsvUploadUpdateProperties(String csvUploadUpdateProperties) {
        this.csvUploadUpdateProperties = csvUploadUpdateProperties;
    }

    public boolean isNonOutputOid() {
        return this.nonOutputOid;
    }

    public void setNonOutputOid(boolean nonOutputOid) {
        this.nonOutputOid = nonOutputOid;
    }

    public boolean isNonOutputReference() {
        return this.nonOutputReference;
    }

    public void setNonOutputReference(boolean nonOutputReference) {
        this.nonOutputReference = nonOutputReference;
    }

    public boolean isNonOutputBinaryRef() {
        return this.nonOutputBinaryRef;
    }

    public void setNonOutputBinaryRef(boolean nonOutputBinaryRef) {
        this.nonOutputBinaryRef = nonOutputBinaryRef;
    }

    public int getConditionDispCount() {
        return this.conditionDispCount;
    }

    public void setConditionDispCount(int conditionDispCount) {
        this.conditionDispCount = conditionDispCount;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public boolean isUnsorted() {
        return this.unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this.unsorted = unsorted;
    }

    public boolean isFulltextSearchSorted() {
        return this.fulltextSearchSorted;
    }

    public void setFulltextSearchSorted(boolean fulltextSearchSorted) {
        this.fulltextSearchSorted = fulltextSearchSorted;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isHideDetailCondition() {
        return this.hideDetailCondition;
    }

    public void setHideDetailCondition(boolean hideDetailCondition) {
        this.hideDetailCondition = hideDetailCondition;
    }

    public boolean isHideFixedCondition() {
        return this.hideFixedCondition;
    }

    public void setHideFixedCondition(boolean hideFixedCondition) {
        this.hideFixedCondition = hideFixedCondition;
    }

    public boolean isHideCsvdownload() {
        return this.hideCsvdownload;
    }

    public void setHideCsvdownload(boolean hideCsvdownload) {
        this.hideCsvdownload = hideCsvdownload;
    }

    public String getCsvdownloadProperties() {
        return this.csvdownloadProperties;
    }

    public void setCsvdownloadProperties(String csvdownloadProperties) {
        this.csvdownloadProperties = csvdownloadProperties;
    }

    public String getCsvdownloadUploadableProperties() {
        return this.csvdownloadUploadableProperties;
    }

    public void setCsvdownloadUploadableProperties(String csvdownloadUploadableProperties) {
        this.csvdownloadUploadableProperties = csvdownloadUploadableProperties;
    }

    public String getCsvdownloadFileNameFormat() {
        return this.csvdownloadFileNameFormat;
    }

    public void setCsvdownloadFileNameFormat(String csvdownloadFileNameFormat) {
        this.csvdownloadFileNameFormat = csvdownloadFileNameFormat;
    }

    public MultipleFormat getCsvMultipleFormat() {
        return this.csvMultipleFormat;
    }

    public void setCsvMultipleFormat(MultipleFormat csvMultipleFormat) {
        this.csvMultipleFormat = csvMultipleFormat;
    }

    public String getDefaultCondition() {
        return this.defaultCondition;
    }

    public void setDefaultCondition(String defaultFilter) {
        this.defaultCondition = defaultFilter;
    }

    public boolean isUseDefaultConditionWithFilterDefinition() {
        return this.useDefaultConditionWithFilterDefinition;
    }

    public void setUseDefaultConditionWithFilterDefinition(boolean useDefaultConditionWithFilterDefinition) {
        this.useDefaultConditionWithFilterDefinition = useDefaultConditionWithFilterDefinition;
    }

    public String getDefaultPropertyConditionScript() {
        return this.defaultPropertyConditionScript;
    }

    public void setDefaultPropertyConditionScript(String defaultPropertyConditionScript) {
        this.defaultPropertyConditionScript = defaultPropertyConditionScript;
    }

    public List<MetaFilterSetting> getFilterSetting() {
        if (this.filterSetting == null) {
            this.filterSetting = new ArrayList<MetaFilterSetting>();
        }
        return this.filterSetting;
    }

    public void setFilterSetting(List<MetaFilterSetting> filterSetting) {
        this.filterSetting = filterSetting;
    }

    public void addFilterSetting(MetaFilterSetting setting) {
        this.getFilterSetting().add(setting);
    }

    public List<MetaElement> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<MetaElement>();
        }
        return this.elements;
    }

    public void setElements(List<MetaElement> elements) {
        this.elements = elements;
    }

    public List<MetaSortSetting> getSortSetting() {
        if (this.sortSetting == null) {
            this.sortSetting = new ArrayList<MetaSortSetting>();
        }
        return this.sortSetting;
    }

    public void setSortSetting(List<MetaSortSetting> sortSetting) {
        this.sortSetting = sortSetting;
    }

    public void addElement(MetaElement element) {
        this.getElements().add(element);
    }

    public void addSortSetting(MetaSortSetting setting) {
        this.getSortSetting().add(setting);
    }

    public MetaSearchConditionSection copy() {
        return (MetaSearchConditionSection)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        Object meta;
        super.fillFrom(element, definitionId);
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler handler = ctx.getHandlerById(definitionId);
        SearchConditionSection section = (SearchConditionSection)element;
        this.conditionDispCount = section.getConditionDispCount();
        this.colNum = section.getColNum();
        this.unsorted = section.isUnsorted();
        this.fulltextSearchSorted = section.isFulltextSearchSorted();
        this.distinct = section.isDistinct();
        this.hideDetailCondition = section.isHideDetailCondition();
        this.hideFixedCondition = section.isHideFixedCondition();
        this.hideCsvdownload = section.isHideCsvdownload();
        this.defaultCondition = section.getDefaultCondition();
        this.useDefaultConditionWithFilterDefinition = section.isUseDefaultConditionWithFilterDefinition();
        this.defaultPropertyConditionScript = section.getDefaultPropertyConditionScript();
        if (section.getElements().size() > 0) {
            for (Element element2 : section.getElements()) {
                MetaElement e = MetaElement.createInstance(element2);
                e.applyConfig(element2, definitionId);
                this.addElement(e);
            }
        }
        this.nonOutputOid = section.isNonOutputOid();
        this.nonOutputReference = section.isNonOutputReference();
        this.nonOutputBinaryRef = section.isNonOutputBinaryRef();
        this.hideCsvUpload = section.isHideCsvUpload();
        this.csvUploadDenyInsert = section.isCsvUploadDenyInsert();
        this.csvUploadDenyUpdate = section.isCsvUploadDenyUpdate();
        this.csvUploadDenyDelete = section.isCsvUploadDenyDelete();
        this.csvUploadInsertProperties = section.getCsvUploadInsertProperties();
        this.csvUploadUpdateProperties = section.getCsvUploadUpdateProperties();
        this.hideCsvdownloadDialog = section.isHideCsvdownloadDialog();
        this.specifyCharacterCode = section.getSpecifyCharacterCode();
        this.csvUploadTransactionType = section.getCsvUploadTransactionType();
        this.csvdownloadMaxCount = section.getCsvdownloadMaxCount();
        this.uploadableCsvdownloadLoadAtOnce = section.isUploadableCsvdownloadLoadAtOnce();
        this.uploadableCsvdownloadLoadSize = section.getUploadableCsvdownloadLoadSize();
        this.csvdownloadProperties = section.getCsvdownloadProperties();
        this.csvdownloadUploadableProperties = section.getCsvdownloadUploadableProperties();
        this.csvdownloadFileNameFormat = section.getCsvdownloadFileNameFormat();
        this.csvMultipleFormat = section.getCsvMultipleFormat();
        if (!section.getSortSetting().isEmpty()) {
            for (SortSetting sortSetting : section.getSortSetting()) {
                meta = new MetaSortSetting();
                ((MetaSortSetting)meta).applyConfig(sortSetting, ctx, handler);
                this.addSortSetting((MetaSortSetting)meta);
            }
        }
        if (!section.getFilterSetting().isEmpty()) {
            for (FilterSetting filterSetting : section.getFilterSetting()) {
                meta = new MetaFilterSetting();
                ((MetaFilterSetting)meta).applyConfig(filterSetting, ctx, handler);
                this.addFilterSetting((MetaFilterSetting)meta);
            }
        }
    }

    @Override
    public Element currentConfig(String definitionId) {
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler handler = ctx.getHandlerById(definitionId);
        SearchConditionSection section = new SearchConditionSection();
        super.fillTo(section, definitionId);
        section.setScriptKey(this.scriptKey);
        section.setConditionDispCount(this.conditionDispCount);
        section.setColNum(this.colNum);
        section.setUnsorted(this.unsorted);
        section.setFulltextSearchSorted(this.fulltextSearchSorted);
        section.setDistinct(this.distinct);
        section.setHideDetailCondition(this.hideDetailCondition);
        section.setHideFixedCondition(this.hideFixedCondition);
        section.setHideCsvdownload(this.hideCsvdownload);
        section.setDefaultCondition(this.defaultCondition);
        section.setUseDefaultConditionWithFilterDefinition(this.useDefaultConditionWithFilterDefinition);
        section.setDefaultPropertyConditionScript(this.defaultPropertyConditionScript);
        if (this.getElements().size() > 0) {
            for (MetaElement metaElement : this.getElements()) {
                Element e = metaElement.currentConfig(definitionId);
                if (e == null) continue;
                section.addElement(e);
            }
        }
        section.setNonOutputOid(this.nonOutputOid);
        section.setNonOutputReference(this.nonOutputReference);
        section.setNonOutputBinaryRef(this.nonOutputBinaryRef);
        section.setHideCsvUpload(this.hideCsvUpload);
        section.setCsvUploadDenyInsert(this.csvUploadDenyInsert);
        section.setCsvUploadDenyUpdate(this.csvUploadDenyUpdate);
        section.setCsvUploadDenyDelete(this.csvUploadDenyDelete);
        section.setCsvUploadInsertProperties(this.csvUploadInsertProperties);
        section.setCsvUploadUpdateProperties(this.csvUploadUpdateProperties);
        section.setHideCsvdownloadDialog(this.hideCsvdownloadDialog);
        section.setSpecifyCharacterCode(this.specifyCharacterCode);
        section.setCsvUploadTransactionType(this.csvUploadTransactionType);
        section.setCsvdownloadMaxCount(this.csvdownloadMaxCount);
        section.setUploadableCsvdownloadLoadAtOnce(this.uploadableCsvdownloadLoadAtOnce);
        section.setUploadableCsvdownloadLoadSize(this.uploadableCsvdownloadLoadSize);
        section.setCsvdownloadProperties(this.csvdownloadProperties);
        section.setCsvdownloadUploadableProperties(this.csvdownloadUploadableProperties);
        section.setCsvdownloadFileNameFormat(this.csvdownloadFileNameFormat);
        section.setCsvMultipleFormat(this.csvMultipleFormat);
        if (!this.getSortSetting().isEmpty()) {
            for (MetaSortSetting metaSortSetting : this.getSortSetting()) {
                SortSetting s = metaSortSetting.currentConfig(ctx, handler);
                if (s == null) continue;
                section.addSortSetting(s);
            }
        }
        if (!this.getFilterSetting().isEmpty()) {
            for (MetaFilterSetting metaFilterSetting : this.getFilterSetting()) {
                section.addFilterSetting(metaFilterSetting.currentConfig(ctx, handler));
            }
        }
        return section;
    }

    @Override
    public SearchConditionSectionRuntime createRuntime(EntityViewRuntime entityView, FormViewRuntime formView) {
        return new SearchConditionSectionRuntime(this, entityView, formView);
    }

    public class SearchConditionSectionRuntime
    extends SectionRuntime {
        public static final String DEFAULT_CONDITION_PREFIX = "SearchConditionSection_defaultCondition_";

        public SearchConditionSectionRuntime(MetaSearchConditionSection metadata, EntityViewRuntime entityView, FormViewRuntime formView) {
            super(metadata, entityView);
            EntityContext context = EntityContext.getCurrentContext();
            EntityHandler eh = context.getHandlerById(entityView.getMetaData().getDefinitionId());
            HashMap<String, GroovyTemplate> customStyleMap = new HashMap<String, GroovyTemplate>();
            List properties = metadata.getElements().stream().filter(e -> e instanceof MetaPropertyItem).map(e -> (MetaPropertyItem)e).collect(Collectors.toList());
            for (MetaPropertyItem property : properties) {
                property.createRuntime(entityView, formView);
                MetaPropertyEditor editor = property.getEditor();
                if (editor == null) continue;
                MetaPropertyEditor.PropertyEditorRuntime runtime = (MetaPropertyEditor.PropertyEditorRuntime)editor.createRuntime(entityView, formView, property, context, eh);
                customStyleMap.put(editor.getInputCustomStyleScriptKey(), runtime.getInputCustomStyleScript());
                customStyleMap.put(editor.getOutputCustomStyleScriptKey(), runtime.getOutputCustomStyleScript());
            }
            metadata.scriptKey = "SearchConditionSection_Style_" + GroovyTemplateCompiler.randomName().replace("-", "_");
            entityView.addCustomStyle(MetaSearchConditionSection.this.scriptKey, customStyleMap);
            if (StringUtil.isNotEmpty((String)MetaSearchConditionSection.this.defaultCondition)) {
                PreparedQuery query = new PreparedQuery(MetaSearchConditionSection.this.defaultCondition);
                entityView.addQuery(DEFAULT_CONDITION_PREFIX + metadata.getElementRuntimeId(), query);
            }
        }
    }
}

