/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.element.section;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.generic.element.section.MetaSection;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.section.TemplateSection;

public class MetaTemplateSection
extends MetaSection {
    private static final long serialVersionUID = 3587801590097006196L;
    private String templateName;
    private String title;
    private String id;
    private boolean showLink;
    private boolean hideDetail;
    private boolean hideView;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private boolean dispBorderInSection;

    public static MetaTemplateSection createInstance(Element element) {
        return new MetaTemplateSection();
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isHideDetail() {
        return this.hideDetail;
    }

    public void setHideDetail(boolean hideDetail) {
        this.hideDetail = hideDetail;
    }

    public boolean isHideView() {
        return this.hideView;
    }

    public void setHideView(boolean hideView) {
        this.hideView = hideView;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public boolean isDispBorderInSection() {
        return this.dispBorderInSection;
    }

    public void setDispBorderInSection(boolean dispBorderInSection) {
        this.dispBorderInSection = dispBorderInSection;
    }

    public MetaSection copy() {
        return (MetaSection)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    @Override
    public void applyConfig(Element element, String definitionId) {
        super.fillFrom(element, definitionId);
        TemplateSection section = (TemplateSection)element;
        this.templateName = section.getTemplateName();
        this.title = section.getTitle();
        this.id = section.getId();
        this.showLink = section.isShowLink();
        this.hideDetail = section.isHideDetail();
        this.hideView = section.isHideView();
        this.dispBorderInSection = section.isDispBorderInSection();
        this.localizedTitleList = I18nUtil.toMeta(section.getLocalizedTitleList());
    }

    @Override
    public Element currentConfig(String definitionId) {
        TemplateSection section = new TemplateSection();
        super.fillTo(section, definitionId);
        section.setTemplateName(this.templateName);
        section.setTitle(this.title);
        section.setId(this.id);
        section.setShowLink(this.showLink);
        section.setHideDetail(this.hideDetail);
        section.setHideView(this.hideView);
        section.setDispBorderInSection(this.dispBorderInSection);
        section.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        return section;
    }
}

