/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.generic.parser;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.view.generic.EntityViewUtil;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.parser.Token;

public class PropertyToken
implements Token {
    private NestProperty property;

    public PropertyToken(NestProperty property) {
        this.property = property;
    }

    @Override
    public void printOut(PageContext page) throws ServletException, IOException {
        String path;
        if (this.property.getEditor() == null) {
            return;
        }
        ServletRequest request = page.getRequest();
        String designType = (String)request.getAttribute("designType");
        if (designType == null) {
            designType = "";
        }
        if ((path = EntityViewUtil.getJspPath(this.property.getEditor(), designType)) != null) {
            Boolean nest = (Boolean)request.getAttribute("nest");
            EntityDefinition ed = (EntityDefinition)request.getAttribute("entityDefinition");
            Entity entity = null;
            if (nest == null || !nest.booleanValue()) {
                entity = (Entity)request.getAttribute("value");
                this.property.getEditor().setPropertyName(this.property.getPropertyName());
            } else {
                entity = (Entity)request.getAttribute("nestValue");
                String prefix = (String)request.getAttribute("nestPrefix");
                this.property.getEditor().setPropertyName(prefix + "." + this.property.getPropertyName());
            }
            PropertyDefinition pd = ed.getProperty(this.property.getPropertyName());
            Object propValue = null;
            if (entity != null) {
                propValue = entity.getValue(this.property.getPropertyName());
            }
            request.setAttribute("editor", (Object)this.property.getEditor());
            request.setAttribute("propValue", propValue);
            request.setAttribute("propertyDefinition", (Object)pd);
            page.include(path);
        }
    }

    @Override
    public String getKey() {
        return this.property.getPropertyName();
    }
}

