/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.menu;

import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.view.menu.MetaMenu;
import org.iplass.mtp.impl.web.actionmapping.ActionMappingService;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.menu.ActionMenuItem;
import org.iplass.mtp.view.menu.MenuItem;

public final class MetaActionMenu
extends MetaMenu {
    private static final long serialVersionUID = 4468943776970244262L;
    String definitionId;
    private String parameter;

    @Override
    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaActionMenuHandler();
    }

    @Override
    public void applyConfig(MenuItem definition) {
        this.fillFrom(definition);
        ActionMenuItem def = (ActionMenuItem)definition;
        this.parameter = def.getParameter();
        ActionMappingService service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        MetaActionMapping.ActionMappingRuntime target = service.getByPathHierarchy(def.getActionName());
        this.definitionId = target == null ? null : target.getMetaData().getId();
    }

    @Override
    public MenuItem currentConfig() {
        if (this.getDefinitionId() == null) {
            return null;
        }
        ActionMappingService service = (ActionMappingService)ServiceRegistry.getRegistry().getService(ActionMappingService.class);
        MetaActionMapping.ActionMappingRuntime target = (MetaActionMapping.ActionMappingRuntime)service.getRuntimeById(this.getDefinitionId());
        if (target == null) {
            return null;
        }
        MetaActionMapping mam = target.getMetaData();
        if (mam == null) {
            return null;
        }
        ActionMenuItem definition = new ActionMenuItem();
        this.fillTo(definition);
        definition.setParameter(this.parameter);
        definition.setActionName(mam.getName());
        return definition;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.definitionId == null ? 0 : this.definitionId.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MetaActionMenu other = (MetaActionMenu)((Object)obj);
        if (this.definitionId == null ? other.definitionId != null : !this.definitionId.equals(other.definitionId)) {
            return false;
        }
        return !(this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetaActionMenu [parameter=");
        builder.append(this.parameter);
        builder.append(", id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", displayName=");
        builder.append(this.displayName);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", definitionId=");
        builder.append(this.definitionId);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append("]");
        return builder.toString();
    }

    public class MetaActionMenuHandler
    extends MetaMenu.MetaMenuHandler {
        public MetaActionMenuHandler() {
            super(MetaActionMenu.this);
        }

        @Override
        public MetaActionMenu getMetaData() {
            return MetaActionMenu.this;
        }
    }
}

