/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.menu;

import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.view.menu.MetaMenu;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.menu.EntityMenuItem;
import org.iplass.mtp.view.menu.MenuItem;

public final class MetaEntityMenu
extends MetaMenu {
    private static final long serialVersionUID = -7349512062871654338L;
    private String definitionId;
    private String parameter;
    private String viewName;
    private boolean executeSearch;

    public MetaEntityMenuHandler createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaEntityMenuHandler();
    }

    @Override
    public void applyConfig(MenuItem definition) {
        this.fillFrom(definition);
        EntityMenuItem def = (EntityMenuItem)definition;
        this.parameter = def.getParameter();
        this.viewName = def.getViewName();
        this.executeSearch = def.isExecuteSearch();
        EntityService ehs = (EntityService)ServiceRegistry.getRegistry().getService(EntityService.class);
        EntityHandler target = ehs.getRuntimeByName(def.getEntityDefinitionName());
        this.definitionId = target == null ? null : target.getMetaData().getId();
    }

    @Override
    public MenuItem currentConfig() {
        if (this.getDefinitionId() == null) {
            return null;
        }
        EntityService ehs = (EntityService)ServiceRegistry.getRegistry().getService(EntityService.class);
        EntityHandler entityHandler = ehs.getRuntimeById(this.getDefinitionId());
        if (entityHandler == null) {
            return null;
        }
        MetaEntity entity = entityHandler.getMetaData();
        if (entity == null) {
            return null;
        }
        EntityMenuItem definition = new EntityMenuItem();
        this.fillTo(definition);
        definition.setParameter(this.parameter);
        definition.setEntityDefinitionName(entity.getName());
        definition.setViewName(this.viewName);
        definition.setExecuteSearch(this.executeSearch);
        return definition;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public boolean isExecuteSearch() {
        return this.executeSearch;
    }

    public void setExecuteSearch(boolean executeSearch) {
        this.executeSearch = executeSearch;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.definitionId == null ? 0 : this.definitionId.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.viewName == null ? 0 : this.viewName.hashCode());
        result = 31 * result + (this.executeSearch ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MetaEntityMenu other = (MetaEntityMenu)((Object)obj);
        if (this.definitionId == null ? other.definitionId != null : !this.definitionId.equals(other.definitionId)) {
            return false;
        }
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        if (this.viewName == null ? other.viewName != null : !this.viewName.equals(other.viewName)) {
            return false;
        }
        return this.executeSearch == other.executeSearch;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MetaEntityMenu [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", displayName=");
        builder.append(this.displayName);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", definitionId=");
        builder.append(this.definitionId);
        builder.append(", viewName=");
        builder.append(this.viewName);
        builder.append(", executeSearch=");
        builder.append(this.executeSearch);
        builder.append(", parameter=");
        builder.append(this.parameter);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append("]");
        return builder.toString();
    }

    public class MetaEntityMenuHandler
    extends MetaMenu.MetaMenuHandler {
        public MetaEntityMenuHandler() {
            super(MetaEntityMenu.this);
        }

        @Override
        public MetaEntityMenu getMetaData() {
            return MetaEntityMenu.this;
        }
    }
}

