/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.menu;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.menu.MetaActionMenu;
import org.iplass.mtp.impl.view.menu.MetaEntityMenu;
import org.iplass.mtp.impl.view.menu.MetaNodeMenu;
import org.iplass.mtp.impl.view.menu.MetaUrlMenu;
import org.iplass.mtp.view.menu.ActionMenuItem;
import org.iplass.mtp.view.menu.EntityMenuItem;
import org.iplass.mtp.view.menu.MenuItem;
import org.iplass.mtp.view.menu.NodeMenuItem;
import org.iplass.mtp.view.menu.UrlMenuItem;

@XmlRootElement
@XmlSeeAlso(value={MetaActionMenu.class, MetaEntityMenu.class, MetaNodeMenu.class, MetaUrlMenu.class})
public abstract class MetaMenu
extends BaseRootMetaData
implements DefinableMetaData<MenuItem> {
    private static final long serialVersionUID = 5233713258294539616L;
    String icon;
    private String iconTag;
    private String imageColor;
    private String customizeScript;

    public MetaMenu copy() {
        return (MetaMenu)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public static MetaMenu createInstance(MenuItem definition) {
        if (definition instanceof ActionMenuItem) {
            return new MetaActionMenu();
        }
        if (definition instanceof EntityMenuItem) {
            return new MetaEntityMenu();
        }
        if (definition instanceof NodeMenuItem) {
            return new MetaNodeMenu();
        }
        if (definition instanceof UrlMenuItem) {
            return new MetaUrlMenu();
        }
        return null;
    }

    public abstract void applyConfig(MenuItem var1);

    protected void fillFrom(MenuItem definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.icon = definition.getImageUrl();
        this.iconTag = definition.getIconTag();
        this.imageColor = definition.getImageColor();
        this.customizeScript = definition.getCustomizeScript();
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
    }

    public abstract MenuItem currentConfig();

    protected void fillTo(MenuItem definition) {
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setImageUrl(this.icon);
        definition.setIconTag(this.iconTag);
        definition.setImageColor(this.imageColor);
        definition.setCustomizeScript(this.customizeScript);
        definition.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(String imageColor) {
        this.imageColor = imageColor;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public void setIconTag(String iconTag) {
        this.iconTag = iconTag;
    }

    public String getCustomizeScript() {
        return this.customizeScript;
    }

    public void setCustomizeScript(String customizeScript) {
        this.customizeScript = customizeScript;
    }

    public abstract MetaDataRuntime createRuntime(MetaDataConfig var1);

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
        result = 31 * result + (this.iconTag == null ? 0 : this.iconTag.hashCode());
        result = 31 * result + (this.imageColor == null ? 0 : this.imageColor.hashCode());
        result = 31 * result + (this.customizeScript == null ? 0 : this.customizeScript.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MetaMenu other = (MetaMenu)((Object)obj);
        if (this.icon == null ? other.icon != null : !this.icon.equals(other.icon)) {
            return false;
        }
        if (this.iconTag == null ? other.iconTag != null : !this.iconTag.equals(other.iconTag)) {
            return false;
        }
        if (this.imageColor != other.imageColor) {
            return false;
        }
        return !(this.customizeScript == null ? other.customizeScript != null : !this.customizeScript.equals(other.customizeScript));
    }

    public abstract class MetaMenuHandler
    extends BaseMetaDataRuntime {
        private static final String SCRIPT_PREFIX = "MetaMenuHandler_customizeScript";
        private Script compiledCustomizeScript;

        public abstract MetaMenu getMetaData();

        public MetaMenuHandler() {
            ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            if (MetaMenu.this.getCustomizeScript() != null) {
                String scriptName = "MetaMenuHandler_customizeScript_" + MetaMenu.this.getId();
                this.compiledCustomizeScript = scriptEngine.createScript(MetaMenu.this.getCustomizeScript(), scriptName);
            }
        }

        public Script getCompiledCustomizeScript() {
            return this.compiledCustomizeScript;
        }
    }
}

