/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.menu.MenuItemService;
import org.iplass.mtp.impl.view.menu.MetaMenu;
import org.iplass.mtp.impl.view.menu.MetaNodeMenu;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.view.menu.MenuItem;

public class MetaMenuItem
implements Serializable {
    private static final long serialVersionUID = -3781564129837689678L;
    private String menuRefId;
    private List<MetaMenuItem> childs;

    public MetaMenuItem copy() {
        return (MetaMenuItem)ObjectUtil.deepCopy((Serializable)this);
    }

    public String getMenuRefId() {
        return this.menuRefId;
    }

    public void setMenuRefId(String menuRefId) {
        this.menuRefId = menuRefId;
    }

    public List<MetaMenuItem> getChilds() {
        return this.childs;
    }

    public void setChilds(List<MetaMenuItem> childs) {
        this.childs = childs;
    }

    public void addChild(MetaMenuItem metaMenuItem) {
        if (this.childs == null) {
            this.childs = new ArrayList<MetaMenuItem>();
        }
        this.childs.add(metaMenuItem);
    }

    public void applyConfig(MenuItem definition) {
        MenuItemService service = (MenuItemService)ServiceRegistry.getRegistry().getService(MenuItemService.class);
        MetaMenu.MetaMenuHandler handler = (MetaMenu.MetaMenuHandler)service.getRuntimeByName(definition.getName());
        this.menuRefId = handler.getMetaData().getId();
        if (definition.getChilds() != null) {
            this.childs = new ArrayList<MetaMenuItem>(definition.getChilds().size());
            for (MenuItem item : definition.getChilds()) {
                MetaMenuItem child = new MetaMenuItem();
                child.applyConfig(item);
                this.childs.add(child);
            }
        } else {
            this.childs = null;
        }
    }

    public MenuItem currentConfig() {
        MenuItemService service = (MenuItemService)ServiceRegistry.getRegistry().getService(MenuItemService.class);
        MetaMenu.MetaMenuHandler handler = (MetaMenu.MetaMenuHandler)service.getRuntimeById(this.menuRefId);
        if (handler == null) {
            return null;
        }
        if (handler instanceof MetaNodeMenu.MetaNodeMenuHandler && (this.childs == null || this.childs.size() == 0)) {
            return null;
        }
        MenuItem item = handler.getMetaData().currentConfig();
        if (item == null) {
            return null;
        }
        if (this.childs == null) {
            return item;
        }
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>(this.childs.size());
        for (MetaMenuItem metaMenuItem : this.childs) {
            MenuItem child = metaMenuItem.currentConfig();
            if (child == null) continue;
            menuItems.add(child);
        }
        if (menuItems.size() != 0) {
            menuItems.trimToSize();
            item.setChilds(menuItems);
        }
        return item;
    }
}

