/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.menu;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.menu.MetaMenuItem;
import org.iplass.mtp.view.menu.MenuItem;
import org.iplass.mtp.view.menu.MenuTree;

@XmlRootElement
public class MetaTreeMenu
extends BaseRootMetaData
implements DefinableMetaData<MenuTree> {
    private static final long serialVersionUID = 4592136234533462455L;
    private Integer displayOrder;
    private boolean showMenuDisplayName;
    private List<MetaMenuItem> childs;

    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaTreeMenuHandler();
    }

    public MetaTreeMenu copy() {
        return (MetaTreeMenu)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(MenuTree definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        this.displayOrder = definition.getDisplayOrder();
        this.showMenuDisplayName = definition.isShowMenuDisplayName();
        if (definition.getMenuItems() != null) {
            this.childs = new ArrayList<MetaMenuItem>(definition.getMenuItems().size());
            for (MenuItem item : definition.getMenuItems()) {
                MetaMenuItem child = new MetaMenuItem();
                child.applyConfig(item);
                this.childs.add(child);
            }
        } else {
            this.childs = null;
        }
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
    }

    public MenuTree currentConfig() {
        MenuTree definition = new MenuTree();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        definition.setDisplayOrder(this.displayOrder);
        definition.setShowMenuDisplayName(this.showMenuDisplayName);
        if (this.childs != null) {
            ArrayList<MenuItem> items = new ArrayList<MenuItem>(this.childs.size());
            for (MetaMenuItem child : this.childs) {
                MenuItem item = child.currentConfig();
                if (item == null) continue;
                items.add(item);
            }
            if (items.size() > 0) {
                items.trimToSize();
            }
            definition.setMenuItems(items);
        }
        definition.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        return definition;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public boolean isShowMenuDisplayName() {
        return this.showMenuDisplayName;
    }

    public void setShowMenuDisplayName(boolean showMenuDisplayName) {
        this.showMenuDisplayName = showMenuDisplayName;
    }

    public List<MetaMenuItem> getChilds() {
        return this.childs;
    }

    public void setChilds(List<MetaMenuItem> childs) {
        this.childs = childs;
    }

    public void addChild(MetaMenuItem metaMenuItem) {
        if (this.childs == null) {
            this.childs = new ArrayList<MetaMenuItem>();
        }
        this.childs.add(metaMenuItem);
    }

    public class MetaTreeMenuHandler
    extends BaseMetaDataRuntime {
        public MetaTreeMenu getMetaData() {
            return MetaTreeMenu.this;
        }
    }
}

