/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.top;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.top.TopViewHandler;
import org.iplass.mtp.impl.view.top.parts.MetaTopViewParts;
import org.iplass.mtp.view.top.TopViewDefinition;
import org.iplass.mtp.view.top.parts.TopViewParts;

public class MetaTopView
extends BaseRootMetaData
implements DefinableMetaData<TopViewDefinition> {
    private static final long serialVersionUID = 6339958147628350370L;
    private List<MetaTopViewParts> parts;
    private List<MetaTopViewParts> widgets;

    public MetaTopView copy() {
        return (MetaTopView)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public TopViewHandler createRuntime(MetaDataConfig metaDataConfig) {
        return new TopViewHandler(this);
    }

    public List<MetaTopViewParts> getParts() {
        if (this.parts == null) {
            this.parts = new ArrayList<MetaTopViewParts>();
        }
        return this.parts;
    }

    public void setParts(List<MetaTopViewParts> parts) {
        this.parts = parts;
    }

    public void addParts(MetaTopViewParts parts) {
        this.getParts().add(parts);
    }

    public List<MetaTopViewParts> getWidgets() {
        if (this.widgets == null) {
            this.widgets = new ArrayList<MetaTopViewParts>();
        }
        return this.widgets;
    }

    public void setWidgets(List<MetaTopViewParts> widgets) {
        this.widgets = widgets;
    }

    public void addWidget(MetaTopViewParts widget) {
        this.getWidgets().add(widget);
    }

    public void applyConfig(TopViewDefinition definition) {
        MetaTopViewParts meta;
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.description = definition.getDescription();
        for (TopViewParts parts : definition.getParts()) {
            meta = MetaTopViewParts.createInstance(parts);
            if (meta == null) continue;
            meta.applyConfig(parts);
            this.addParts(meta);
        }
        for (TopViewParts widget : definition.getWidgets()) {
            meta = MetaTopViewParts.createInstance(widget);
            if (meta == null) continue;
            meta.applyConfig(widget);
            this.addWidget(meta);
        }
    }

    public TopViewDefinition currentConfig() {
        TopViewParts parts;
        TopViewDefinition definition = new TopViewDefinition();
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setDescription(this.description);
        for (MetaTopViewParts meta : this.getParts()) {
            parts = meta.currentConfig();
            if (parts == null) continue;
            definition.addParts(parts);
        }
        for (MetaTopViewParts meta : this.getWidgets()) {
            parts = meta.currentConfig();
            if (parts == null) continue;
            definition.addWidget(parts);
        }
        return definition;
    }
}

