/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.top;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.view.top.MetaTopView;
import org.iplass.mtp.impl.view.top.parts.MetaTopViewParts;
import org.iplass.mtp.impl.view.top.parts.TopViewPartsHandler;

public class TopViewHandler
extends BaseMetaDataRuntime {
    private MetaTopView metadata;
    private List<TopViewPartsHandler> parts;
    private List<TopViewPartsHandler> widgets;
    private Map<String, TopViewPartsHandler> handlerMap;

    public TopViewHandler(MetaTopView metadata) {
        try {
            TopViewPartsHandler handler;
            this.metadata = metadata;
            this.handlerMap = new HashMap<String, TopViewPartsHandler>();
            this.parts = new ArrayList<TopViewPartsHandler>();
            for (MetaTopViewParts meta : metadata.getParts()) {
                handler = meta.createRuntime(this);
                this.parts.add(handler);
                if (handler.getHandlerKey() == null) continue;
                this.handlerMap.put(handler.getHandlerKey(), handler);
            }
            this.widgets = new ArrayList<TopViewPartsHandler>();
            for (MetaTopViewParts meta : metadata.getWidgets()) {
                handler = meta.createRuntime(this);
                this.widgets.add(handler);
                if (handler.getHandlerKey() == null) continue;
                this.handlerMap.put(handler.getHandlerKey(), handler);
            }
        }
        catch (RuntimeException e) {
            this.setIllegalStateException(e);
        }
    }

    public MetaTopView getMetaData() {
        return this.metadata;
    }

    public void loadParts(HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) {
        this.checkState();
        int cnt = 0;
        for (TopViewPartsHandler handler : this.parts) {
            try {
                req.setAttribute("partsType", (Object)"Parts");
                req.setAttribute("partsCnt", (Object)cnt);
                handler.setAttribute(req);
                handler.loadParts(req, res, application, page);
                handler.clearAttribute(req);
                req.removeAttribute("partsType");
                cnt = (Integer)req.getAttribute("partsCnt") + 1;
                req.removeAttribute("partsCnt");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void loadWidgets(HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) {
        this.checkState();
        for (TopViewPartsHandler handler : this.widgets) {
            try {
                req.setAttribute("partsType", (Object)"Widget");
                handler.setAttribute(req);
                handler.loadWidgets(req, res, application, page);
                handler.clearAttribute(req);
                req.removeAttribute("partsType");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public List<TopViewPartsHandler> getParts() {
        return this.parts;
    }

    public List<TopViewPartsHandler> getWidgets() {
        return this.widgets;
    }

    public TopViewPartsHandler getHandler(String key) {
        return this.handlerMap.get(key);
    }
}

