/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.top.parts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.top.TopViewHandler;
import org.iplass.mtp.impl.view.top.parts.MetaTemplateParts;
import org.iplass.mtp.impl.view.top.parts.MetaTopViewParts;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.EntityView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.FormViewUtil;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.top.parts.EntityListParts;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.web.template.TemplateUtil;

public class MetaEntityListParts
extends MetaTemplateParts {
    private static final long serialVersionUID = 9029097706504538709L;
    private String definitionId;
    private String viewName;
    private String viewNameForLink;
    private String viewNameForDetail;
    private String filterName;
    private String title;
    private Integer height;
    private boolean searchAsync;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private String iconTag;

    public static MetaEntityListParts createInstance(TopViewParts parts) {
        return new MetaEntityListParts();
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getViewNameForLink() {
        return this.viewNameForLink;
    }

    public void setViewNameForLink(String viewNameForLink) {
        this.viewNameForLink = viewNameForLink;
    }

    public String getViewNameForDetail() {
        return this.viewNameForDetail;
    }

    public void setViewNameForDetail(String viewNameForDetail) {
        this.viewNameForDetail = viewNameForDetail;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public boolean isSearchAsync() {
        return this.searchAsync;
    }

    public void setSearchAsync(boolean searchAsync) {
        this.searchAsync = searchAsync;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public void setIconTag(String iconTag) {
        this.iconTag = iconTag;
    }

    @Override
    public void applyConfig(TopViewParts parts) {
        EntityListParts e = (EntityListParts)parts;
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler entity = context.getHandlerByName(e.getDefName());
        this.fillFrom(e);
        if (entity == null) {
            return;
        }
        this.definitionId = entity.getMetaData().getId();
        this.viewName = e.getViewName();
        this.viewNameForLink = e.getViewNameForLink();
        this.viewNameForDetail = e.getViewNameForDetail();
        this.filterName = e.getFilterName();
        this.title = e.getTitle();
        this.height = e.getHeight();
        this.searchAsync = e.isSearchAsync();
        this.localizedTitleList = I18nUtil.toMeta(e.getLocalizedTitleList());
        this.iconTag = e.getIconTag();
    }

    @Override
    public TopViewParts currentConfig() {
        EntityListParts parts = new EntityListParts();
        EntityContext context = EntityContext.getCurrentContext();
        EntityHandler entity = null;
        this.fillTo(parts);
        if (this.definitionId != null && (entity = context.getHandlerById(this.definitionId)) != null) {
            parts.setDefName(entity.getMetaData().getName());
        }
        parts.setViewName(this.viewName);
        parts.setViewNameForLink(this.viewNameForLink);
        parts.setViewNameForDetail(this.viewNameForDetail);
        parts.setFilterName(this.filterName);
        parts.setTitle(this.title);
        parts.setHeight(this.height);
        parts.setSearchAsync(this.searchAsync);
        parts.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        parts.setIconTag(this.iconTag);
        return parts;
    }

    @Override
    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    @Override
    public MetaTemplateParts.TemplatePartsHandler createRuntime(TopViewHandler topView) {
        return new MetaTemplateParts.TemplatePartsHandler((MetaTopViewParts)this){
            private static final String TEMPLATE_PATH = "gem/generic/search/list";
            private static final String TEMPLATE_PATH_WIDGET = "gem/generic/search/listWidget";

            @Override
            public boolean isParts() {
                return this.checkEntity();
            }

            @Override
            public boolean isWidget() {
                return this.checkEntity();
            }

            @Override
            public String getTemplatePathForParts(HttpServletRequest req) {
                return TEMPLATE_PATH;
            }

            @Override
            public String getTemplatePathForWidget(HttpServletRequest req) {
                return TEMPLATE_PATH_WIDGET;
            }

            @Override
            public void setAttribute(HttpServletRequest req) {
                EntityContext context = EntityContext.getCurrentContext();
                if (MetaEntityListParts.this.definitionId == null) {
                    return;
                }
                RequestContext request = WebUtil.getRequestContext();
                request.setAttribute("partsCnt", req.getAttribute("partsCnt"));
                SearchFormView form = null;
                String title = I18nUtil.stringMeta((String)MetaEntityListParts.this.title, (List)MetaEntityListParts.this.localizedTitleList);
                EntityHandler handler = context.getHandlerById(MetaEntityListParts.this.definitionId);
                if (handler != null) {
                    EntityDefinition ed = handler.getMetaData().currentConfig();
                    EntityViewManager evm = (EntityViewManager)ManagerLocator.manager(EntityViewManager.class);
                    EntityView ev = (EntityView)evm.get(ed.getName());
                    if (ev != null) {
                        form = StringUtil.isEmpty((String)MetaEntityListParts.this.viewName) ? (ev.getSearchFormViewNames().length > 0 ? ev.getDefaultSearchFormView() : FormViewUtil.createDefaultSearchFormView(ed)) : ev.getSearchFormView(MetaEntityListParts.this.viewName);
                    }
                    if (form == null) {
                        form = FormViewUtil.createDefaultSearchFormView(ed);
                    }
                    if (StringUtil.isEmpty((String)title)) {
                        title = TemplateUtil.getMultilingualString((String)form.getTitle(), form.getLocalizedTitleList());
                    }
                    if (StringUtil.isEmpty((String)title)) {
                        title = TemplateUtil.getMultilingualString((String)ed.getDisplayName(), (List)ed.getLocalizedDisplayNameList());
                    }
                }
                request.setAttribute("entityListParts", (Object)MetaEntityListParts.this.currentConfig());
                request.setAttribute("searchFormView", form);
                request.setAttribute("title", (Object)title);
            }

            @Override
            public void clearAttribute(HttpServletRequest req) {
            }

            private boolean checkEntity() {
                EntityViewManager em;
                EntityView ev;
                if (MetaEntityListParts.this.definitionId == null) {
                    return false;
                }
                EntityContext context = EntityContext.getCurrentContext();
                EntityHandler entity = context.getHandlerById(MetaEntityListParts.this.definitionId);
                if (entity == null) {
                    return false;
                }
                return MetaEntityListParts.this.viewName == null || MetaEntityListParts.this.viewName.isEmpty() || (ev = (EntityView)(em = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class)).get(entity.getMetaData().getName())) != null && ev.getSearchFormView(MetaEntityListParts.this.viewName) != null;
            }
        };
    }
}

