/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.top.parts;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.top.TopViewHandler;
import org.iplass.mtp.impl.view.top.parts.MetaActionParts;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.editor.DateTimePropertyEditor;
import org.iplass.mtp.view.top.parts.InformationParts;
import org.iplass.mtp.view.top.parts.TopViewParts;
import org.iplass.mtp.web.template.TemplateUtil;

public class MetaInformationParts
extends MetaActionParts {
    private static final long serialVersionUID = 4886385116507508802L;
    private String title;
    private List<MetaLocalizedString> localizedTitleList = new ArrayList<MetaLocalizedString>();
    private String iconTag;
    private DateTimePropertyEditor.TimeDispRange dispRange;
    private Boolean showWarningPasswordAge;
    private Integer passwordWarningAge;
    private String passwordWarningMessage;
    private List<MetaLocalizedString> localizedPasswordWarningMessageList = new ArrayList<MetaLocalizedString>();
    private String passwordWarnAreaStyleClass;
    private String passwordWarnMarkStyleClass;
    private boolean availableHtmlTag = false;
    private boolean useRichtextEditor;
    private String richtextEditorOption;
    private String detailCustomStyle;
    private Integer numberOfDisplay;

    public static MetaInformationParts createInstance(TopViewParts parts) {
        return new MetaInformationParts();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<MetaLocalizedString> getLocalizedTitleList() {
        return this.localizedTitleList;
    }

    public void setLocalizedTitleList(List<MetaLocalizedString> localizedTitleList) {
        this.localizedTitleList = localizedTitleList;
    }

    public String getIconTag() {
        return this.iconTag;
    }

    public void setIconTag(String iconTag) {
        this.iconTag = iconTag;
    }

    public DateTimePropertyEditor.TimeDispRange getDispRange() {
        return this.dispRange;
    }

    public void setDispRange(DateTimePropertyEditor.TimeDispRange dispRange) {
        this.dispRange = dispRange;
    }

    public Boolean isShowWarningPasswordAge() {
        return this.showWarningPasswordAge != null ? this.showWarningPasswordAge : false;
    }

    public void setShowWarningPasswordAge(Boolean showWarningPasswordAge) {
        this.showWarningPasswordAge = showWarningPasswordAge;
    }

    public Integer getPasswordWarningAge() {
        return this.passwordWarningAge != null ? this.passwordWarningAge : 0;
    }

    public void setPasswordWarningAge(Integer passwordWarningAge) {
        this.passwordWarningAge = passwordWarningAge;
    }

    public String getPasswordWarningMessage() {
        return this.passwordWarningMessage;
    }

    public void setPasswordWarningMessage(String passwordWarningMessage) {
        this.passwordWarningMessage = passwordWarningMessage;
    }

    public List<MetaLocalizedString> getLocalizedPasswordWarningMessageList() {
        return this.localizedPasswordWarningMessageList;
    }

    public void setLocalizedPasswordWarningMessageList(List<MetaLocalizedString> localizedPasswordWarningMessageList) {
        this.localizedPasswordWarningMessageList = localizedPasswordWarningMessageList;
    }

    public String getPasswordWarnAreaStyleClass() {
        return this.passwordWarnAreaStyleClass;
    }

    public void setPasswordWarnAreaStyleClass(String passwordWarnAreaStyleClass) {
        this.passwordWarnAreaStyleClass = passwordWarnAreaStyleClass;
    }

    public String getPasswordWarnMarkStyleClass() {
        return this.passwordWarnMarkStyleClass;
    }

    public void setPasswordWarnMarkStyleClass(String passwordWarnMarkStyleClass) {
        this.passwordWarnMarkStyleClass = passwordWarnMarkStyleClass;
    }

    public boolean isAvailableHtmlTag() {
        return this.availableHtmlTag;
    }

    public void setAvailableHtmlTag(boolean availableHtmlTag) {
        this.availableHtmlTag = availableHtmlTag;
    }

    public Integer getNumberOfDisplay() {
        return this.numberOfDisplay;
    }

    public void setNumberOfDisplay(Integer numberOfDisplay) {
        this.numberOfDisplay = numberOfDisplay;
    }

    public boolean isUseRichtextEditor() {
        return this.useRichtextEditor;
    }

    public void setUseRichtextEditor(boolean useRichtextEditor) {
        this.useRichtextEditor = useRichtextEditor;
    }

    public String getRichtextEditorOption() {
        return this.richtextEditorOption;
    }

    public void setRichtextEditorOption(String richtextEditorOption) {
        this.richtextEditorOption = richtextEditorOption;
    }

    public String getDetailCustomStyle() {
        return this.detailCustomStyle;
    }

    public void setDetailCustomStyle(String detailCustomStyle) {
        this.detailCustomStyle = detailCustomStyle;
    }

    @Override
    public void applyConfig(TopViewParts parts) {
        InformationParts definition = (InformationParts)parts;
        this.fillFrom(definition);
        this.title = definition.getTitle();
        this.dispRange = definition.getDispRange();
        this.localizedTitleList = I18nUtil.toMeta(definition.getLocalizedTitleList());
        this.iconTag = definition.getIconTag();
        this.showWarningPasswordAge = definition.isShowWarningPasswordAge();
        this.passwordWarningAge = definition.getPasswordWarningAge();
        this.passwordWarningMessage = definition.getPasswordWarningMessage();
        this.localizedPasswordWarningMessageList = I18nUtil.toMeta(definition.getLocalizedPasswordWarningMessageList());
        this.passwordWarnAreaStyleClass = definition.getPasswordWarnAreaStyleClass();
        this.passwordWarnMarkStyleClass = definition.getPasswordWarnMarkStyleClass();
        this.availableHtmlTag = definition.isEnableHtmlTag();
        this.useRichtextEditor = definition.isUseRichtextEditor();
        this.richtextEditorOption = definition.getRichtextEditorOption();
        this.detailCustomStyle = definition.getDetailCustomStyle();
        this.numberOfDisplay = definition.getNumberOfDisplay();
    }

    @Override
    public TopViewParts currentConfig() {
        InformationParts parts = new InformationParts();
        this.fillTo(parts);
        parts.setTitle(this.title);
        parts.setDispRange(this.dispRange);
        parts.setLocalizedTitleList(I18nUtil.toDef(this.localizedTitleList));
        parts.setIconTag(this.iconTag);
        parts.setShowWarningPasswordAge(this.showWarningPasswordAge);
        parts.setPasswordWarningAge(this.passwordWarningAge);
        parts.setPasswordWarningMessage(this.passwordWarningMessage);
        parts.setLocalizedPasswordWarningMessageList(I18nUtil.toDef(this.localizedPasswordWarningMessageList));
        parts.setPasswordWarnAreaStyleClass(this.passwordWarnAreaStyleClass);
        parts.setPasswordWarnMarkStyleClass(this.passwordWarnMarkStyleClass);
        parts.setEnableHtmlTag(this.availableHtmlTag);
        parts.setUseRichtextEditor(this.useRichtextEditor);
        parts.setRichtextEditorOption(this.richtextEditorOption);
        parts.setDetailCustomStyle(this.detailCustomStyle);
        parts.setNumberOfDisplay(this.numberOfDisplay);
        return parts;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    @Override
    public MetaActionParts.ActionPartsHandler createRuntime(TopViewHandler topView) {
        return new InformationPartsHandler(this, topView);
    }

    public class InformationPartsHandler
    extends MetaActionParts.ActionPartsHandler {
        private static final String ACTION_NAME_GEM = "gem/information/list";
        private static final String SCRIPT_PREFIX_CUSTOM_STYLE = "InformationPartsHandler_customStyle";
        private final GroovyTemplate detailCustomStyle;

        public InformationPartsHandler(MetaInformationParts meta, TopViewHandler topView) {
            super(meta);
            if (meta.detailCustomStyle != null) {
                ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                String templateName = "InformationPartsHandler_customStyle_" + topView.getMetaData().getId() + GroovyTemplateCompiler.randomName().replace("-", "_");
                this.detailCustomStyle = GroovyTemplateCompiler.compile((String)meta.detailCustomStyle, (String)templateName, (GroovyScriptEngine)((GroovyScriptEngine)scriptEngine));
            } else {
                this.detailCustomStyle = null;
            }
        }

        @Override
        public boolean isParts() {
            return true;
        }

        @Override
        public boolean isWidget() {
            return false;
        }

        @Override
        public String getActionNameForParts(HttpServletRequest req) {
            return ACTION_NAME_GEM;
        }

        @Override
        public String getActionNameForWidget(HttpServletRequest req) {
            return null;
        }

        @Override
        public void setAttribute(HttpServletRequest req) {
            RequestContext request = TemplateUtil.getRequestContext();
            request.setAttribute("infoSetting", (Object)MetaInformationParts.this.currentConfig());
        }

        @Override
        public void clearAttribute(HttpServletRequest req) {
            RequestContext request = TemplateUtil.getRequestContext();
            request.setAttribute("infoSetting", null);
        }

        public String getDetailCustomStyle(Entity entity) {
            if (this.detailCustomStyle == null) {
                return "";
            }
            HashMap<String, Timestamp> bindings = new HashMap<String, Timestamp>();
            bindings.put("today", DateUtil.getCurrentTimestamp());
            bindings.put("entity", (Timestamp)entity);
            StringWriter sw = new StringWriter();
            try {
                this.detailCustomStyle.doTemplate(new GroovyTemplateBinding((Writer)sw, bindings));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String style = sw.toString();
            if (StringUtil.isNotEmpty((String)style)) {
                style = StringUtil.removeLineFeedCode((String)StringUtil.stripToEmpty((String)style)).replaceAll("\t", "");
            }
            return style;
        }
    }
}

