/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.top.parts;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.top.TopViewHandler;
import org.iplass.mtp.impl.view.top.parts.MetaTopViewContentParts;
import org.iplass.mtp.impl.view.top.parts.MetaTopViewParts;
import org.iplass.mtp.impl.view.top.parts.TopViewPartsHandler;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.top.parts.SeparatorParts;
import org.iplass.mtp.view.top.parts.TopViewParts;

public class MetaSeparatorParts
extends MetaTopViewContentParts {
    private static final long serialVersionUID = 7481198924024805153L;
    private MetaTopViewParts leftParts;
    private MetaTopViewParts rightParts;

    public static MetaSeparatorParts createInstance(TopViewParts parts) {
        return new MetaSeparatorParts();
    }

    public MetaTopViewParts getLeftParts() {
        return this.leftParts;
    }

    public void setLeftParts(MetaTopViewParts leftParts) {
        this.leftParts = leftParts;
    }

    public MetaTopViewParts getRightParts() {
        return this.rightParts;
    }

    public void setRightParts(MetaTopViewParts rightParts) {
        this.rightParts = rightParts;
    }

    @Override
    public void applyConfig(TopViewParts parts) {
        SeparatorParts separator = (SeparatorParts)parts;
        this.fillFrom(separator);
        this.leftParts = MetaTopViewParts.createInstance(separator.getLeftParts());
        if (this.leftParts != null) {
            this.leftParts.applyConfig(separator.getLeftParts());
        }
        this.rightParts = MetaTopViewParts.createInstance(separator.getRightParts());
        if (this.rightParts != null) {
            this.rightParts.applyConfig(separator.getRightParts());
        }
    }

    @Override
    public SeparatorParts currentConfig() {
        TopViewParts rp;
        TopViewParts lp;
        SeparatorParts parts = new SeparatorParts();
        this.fillTo(parts);
        if (this.leftParts != null && (lp = this.leftParts.currentConfig()) != null) {
            parts.setLeftParts(lp);
        }
        if (this.rightParts != null && (rp = this.rightParts.currentConfig()) != null) {
            parts.setRightParts(rp);
        }
        return parts;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    @Override
    public TopViewPartsHandler createRuntime(TopViewHandler topView) {
        return new SeparatorPartsHandler(topView, this);
    }

    public class SeparatorPartsHandler
    extends TopViewPartsHandler {
        private TopViewPartsHandler leftParts;
        private TopViewPartsHandler rightParts;

        public SeparatorPartsHandler(TopViewHandler topView, MetaSeparatorParts metadata) {
            super(metadata);
            if (metadata.getLeftParts() != null) {
                this.leftParts = metadata.getLeftParts().createRuntime(topView);
            }
            if (metadata.getRightParts() != null) {
                this.rightParts = metadata.getRightParts().createRuntime(topView);
            }
        }

        @Override
        public void loadParts(HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) throws IOException, ServletException {
            String separatorClass = null;
            String separatorLeftClass = null;
            String separatorRightClass = null;
            String designType = (String)req.getAttribute("designType");
            if ("gem".equals(designType)) {
                separatorClass = "col2-wrap";
                if (StringUtil.isNotBlank((String)MetaSeparatorParts.this.getStyle())) {
                    separatorClass = separatorClass + " " + MetaSeparatorParts.this.getStyle();
                }
                separatorLeftClass = "col-left";
                separatorRightClass = "col-right";
            }
            JspWriter writer = page.getOut();
            writer.write("<div class=\"" + separatorClass + "\">\n");
            writer.write("<div class=\"" + separatorLeftClass + "\">\n");
            if (this.leftParts != null) {
                this.leftParts.setAttribute(req);
                this.leftParts.loadParts(req, res, application, page);
                this.leftParts.clearAttribute(req);
            }
            writer.write("</div>\n");
            writer.write("<div class=\"" + separatorRightClass + "\">\n");
            if (this.rightParts != null) {
                if (req.getAttribute("partsCnt") != null) {
                    req.setAttribute("partsCnt", (Object)((Integer)req.getAttribute("partsCnt") + 1));
                }
                this.rightParts.setAttribute(req);
                this.rightParts.loadParts(req, res, application, page);
                this.rightParts.clearAttribute(req);
            }
            writer.write("</div>\n");
            writer.write("</div>\n");
        }

        @Override
        public void loadWidgets(HttpServletRequest req, HttpServletResponse res, ServletContext application, PageContext page) throws IOException, ServletException {
        }

        @Override
        public void setAttribute(HttpServletRequest req) {
        }

        @Override
        public void clearAttribute(HttpServletRequest req) {
        }

        public TopViewPartsHandler leftParts() {
            return this.leftParts;
        }

        public TopViewPartsHandler rightParts() {
            return this.rightParts;
        }
    }
}

