/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.treeview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.treeview.MetaTreeViewGridColModel;
import org.iplass.mtp.impl.view.treeview.MetaTreeViewItem;
import org.iplass.mtp.view.treeview.TreeView;
import org.iplass.mtp.view.treeview.TreeViewGridColModel;
import org.iplass.mtp.view.treeview.TreeViewItem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class MetaTreeView
extends BaseRootMetaData
implements DefinableMetaData<TreeView> {
    private static final long serialVersionUID = -3133231241912699539L;
    private List<MetaTreeViewItem> items;
    private List<MetaTreeViewGridColModel> colModel;

    public MetaTreeView copy() {
        return (MetaTreeView)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new TreeViewHandler();
    }

    public List<MetaTreeViewItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<MetaTreeViewItem>();
        }
        return this.items;
    }

    public void setItems(List<MetaTreeViewItem> items) {
        this.items = items;
    }

    public void addItem(MetaTreeViewItem item) {
        this.getItems().add(item);
    }

    public List<MetaTreeViewGridColModel> getColModel() {
        if (this.colModel == null) {
            this.colModel = new ArrayList<MetaTreeViewGridColModel>();
        }
        return this.colModel;
    }

    public void setColModel(List<MetaTreeViewGridColModel> colModel) {
        this.colModel = colModel;
    }

    public void addColModel(MetaTreeViewGridColModel colModel) {
        this.getColModel().add(colModel);
    }

    public void applyConfig(TreeView treeView) {
        Object meta;
        this.name = treeView.getName();
        this.displayName = treeView.getDisplayName();
        this.description = treeView.getDescription();
        for (TreeViewItem item : treeView.getItems()) {
            meta = MetaTreeViewItem.getInstance(item);
            ((MetaTreeViewItem)meta).applyConfig(item);
            this.addItem((MetaTreeViewItem)meta);
        }
        this.localizedDisplayNameList = I18nUtil.toMeta(treeView.getLocalizedDisplayNameList());
        for (TreeViewGridColModel model : treeView.getColModel()) {
            meta = new MetaTreeViewGridColModel();
            ((MetaTreeViewGridColModel)meta).applyConfig(model);
            this.addColModel((MetaTreeViewGridColModel)meta);
        }
    }

    public TreeView currentConfig() {
        TreeView treeView = new TreeView();
        treeView.setName(this.name);
        treeView.setDisplayName(this.displayName);
        treeView.setDescription(this.description);
        for (MetaTreeViewItem item : this.getItems()) {
            treeView.addItem(item.currentConfig());
        }
        treeView.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        for (MetaTreeViewGridColModel model : this.getColModel()) {
            treeView.addColModel(model.currentConfig());
        }
        return treeView;
    }

    public class TreeViewHandler
    extends BaseMetaDataRuntime {
        public MetaTreeView getMetaData() {
            return MetaTreeView.this;
        }
    }
}

