/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.treeview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.view.treeview.TreeViewGridColModel;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetaTreeViewGridColModel
implements Serializable {
    private static final long serialVersionUID = 915984050870179425L;
    private String name;
    private String displayLabel;
    private Integer width;
    private String align;
    private List<MetaLocalizedString> localizedDisplayLabelList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayLabel() {
        return this.displayLabel;
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public List<MetaLocalizedString> getLocalizedDisplayLabelList() {
        return this.localizedDisplayLabelList;
    }

    public void setLocalizedDisplayLabelList(List<MetaLocalizedString> localizedDisplayLabelList) {
        this.localizedDisplayLabelList = localizedDisplayLabelList;
    }

    public void addLocalizedDisplayLabel(MetaLocalizedString localizedDisplayLabel) {
        if (this.localizedDisplayLabelList == null) {
            this.localizedDisplayLabelList = new ArrayList<MetaLocalizedString>();
        }
        this.localizedDisplayLabelList.add(localizedDisplayLabel);
    }

    public void applyConfig(TreeViewGridColModel colModel) {
        this.name = colModel.getName();
        this.displayLabel = colModel.getDisplayLabel();
        this.width = colModel.getWidth();
        this.align = colModel.getAlign();
        this.localizedDisplayLabelList = I18nUtil.toMeta(colModel.getLocalizedDisplayLabelList());
    }

    public TreeViewGridColModel currentConfig() {
        TreeViewGridColModel model = new TreeViewGridColModel();
        model.setName(this.name);
        model.setDisplayLabel(this.displayLabel);
        model.setWidth(this.width);
        model.setAlign(this.align);
        model.setLocalizedDisplayLabelList(I18nUtil.toDef(this.localizedDisplayLabelList));
        return model;
    }
}

