/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.view.treeview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.view.treeview.MetaEntityTreeViewItem;
import org.iplass.mtp.impl.view.treeview.MetaReferenceTreeViewItem;
import org.iplass.mtp.impl.view.treeview.MetaTreeViewGridColModelMapping;
import org.iplass.mtp.view.treeview.EntityTreeViewItem;
import org.iplass.mtp.view.treeview.ReferenceTreeViewItem;
import org.iplass.mtp.view.treeview.TreeViewGridColModelMapping;
import org.iplass.mtp.view.treeview.TreeViewItem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={MetaEntityTreeViewItem.class})
public abstract class MetaTreeViewItem
implements MetaData {
    private static final long serialVersionUID = -2173439410019057509L;
    protected String definitionId;
    protected String action;
    protected String viewName;
    protected String sortItem;
    protected TreeViewItem.TreeSortType sortType;
    protected int limit;
    protected String displayPropertyId;
    protected boolean displayDefinitionNode;
    protected List<MetaReferenceTreeViewItem> referenceTreeViewItems;
    protected String entityNodeIcon;
    protected String indexNodeIcon;
    protected String entityDefinitionNodeIcon;
    protected String entityNodeCssStyle;
    protected String indexNodeCssStyle;
    protected String entityDefinitionNodeCssStyle;
    private List<MetaTreeViewGridColModelMapping> mapping;

    public static MetaTreeViewItem getInstance(TreeViewItem item) {
        if (item instanceof EntityTreeViewItem) {
            return MetaEntityTreeViewItem.getInstance(item);
        }
        return null;
    }

    public String getDefinitionId() {
        return this.definitionId;
    }

    public void setDefinitionId(String definitionId) {
        this.definitionId = definitionId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getSortItem() {
        return this.sortItem;
    }

    public void setSortItem(String sortItem) {
        this.sortItem = sortItem;
    }

    public TreeViewItem.TreeSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(TreeViewItem.TreeSortType sortType) {
        this.sortType = sortType;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getDisplayPropertyId() {
        return this.displayPropertyId;
    }

    public void setDisplayPropertyId(String displayPropertyName) {
        this.displayPropertyId = displayPropertyName;
    }

    public boolean isDisplayDefinitionNode() {
        return this.displayDefinitionNode;
    }

    public void setDisplayDefinitionNode(boolean displayDefinitionNode) {
        this.displayDefinitionNode = displayDefinitionNode;
    }

    public List<MetaReferenceTreeViewItem> getReferenceTreeViewItems() {
        if (this.referenceTreeViewItems == null) {
            this.referenceTreeViewItems = new ArrayList<MetaReferenceTreeViewItem>();
        }
        return this.referenceTreeViewItems;
    }

    public void setReferenceTreeViewItems(List<MetaReferenceTreeViewItem> referenceTreeViewItems) {
        this.referenceTreeViewItems = referenceTreeViewItems;
    }

    public void addReferenceTreeViewItem(MetaReferenceTreeViewItem referenceTreeViewItem) {
        this.getReferenceTreeViewItems().add(referenceTreeViewItem);
    }

    public String getEntityNodeIcon() {
        return this.entityNodeIcon;
    }

    public void setEntityNodeIcon(String entityNodeIcon) {
        this.entityNodeIcon = entityNodeIcon;
    }

    public String getIndexNodeIcon() {
        return this.indexNodeIcon;
    }

    public void setIndexNodeIcon(String indexNodeIcon) {
        this.indexNodeIcon = indexNodeIcon;
    }

    public String getEntityDefinitionNodeIcon() {
        return this.entityDefinitionNodeIcon;
    }

    public void setEntityDefinitionNodeIcon(String entityDefinitionNodeIcon) {
        this.entityDefinitionNodeIcon = entityDefinitionNodeIcon;
    }

    public String getEntityNodeCssStyle() {
        return this.entityNodeCssStyle;
    }

    public void setEntityNodeCssStyle(String entityNodeCssStyle) {
        this.entityNodeCssStyle = entityNodeCssStyle;
    }

    public String getIndexNodeCssStyle() {
        return this.indexNodeCssStyle;
    }

    public void setIndexNodeCssStyle(String indexNodeCssStyle) {
        this.indexNodeCssStyle = indexNodeCssStyle;
    }

    public String getEntityDefinitionNodeCssStyle() {
        return this.entityDefinitionNodeCssStyle;
    }

    public void setEntityDefinitionNodeCssStyle(String entityDefinitionNodeCssStyle) {
        this.entityDefinitionNodeCssStyle = entityDefinitionNodeCssStyle;
    }

    public List<MetaTreeViewGridColModelMapping> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<MetaTreeViewGridColModelMapping>();
        }
        return this.mapping;
    }

    public void setMapping(List<MetaTreeViewGridColModelMapping> mapping) {
        this.mapping = mapping;
    }

    public void addMapping(MetaTreeViewGridColModelMapping mapping) {
        this.getMapping().add(mapping);
    }

    public abstract void applyConfig(TreeViewItem var1);

    protected void fillFrom(TreeViewItem item) {
        Object meta;
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler handler = ctx.getHandlerByName(item.getDefName());
        PropertyHandler property = handler.getProperty(item.getDisplayPropertyName(), ctx);
        PropertyHandler sortProperty = null;
        if (item.getSortItem() != null) {
            sortProperty = handler.getProperty(item.getSortItem(), ctx);
        }
        this.definitionId = handler.getMetaData().getId();
        this.action = item.getAction();
        this.viewName = item.getViewName();
        this.sortItem = sortProperty != null ? sortProperty.getId() : null;
        this.sortType = item.getSortType();
        this.limit = item.getLimit();
        this.displayPropertyId = property.getId();
        this.displayDefinitionNode = item.isDisplayDefinitionNode();
        this.entityNodeIcon = item.getEntityNodeIcon();
        this.indexNodeIcon = item.getIndexNodeIcon();
        this.entityDefinitionNodeIcon = item.getEntityDefinitionNodeIcon();
        this.entityNodeCssStyle = item.getEntityNodeCssStyle();
        this.indexNodeCssStyle = item.getIndexNodeCssStyle();
        this.entityDefinitionNodeCssStyle = item.getEntityDefinitionNodeCssStyle();
        for (ReferenceTreeViewItem rItem : item.getReferenceTreeViewItems()) {
            meta = new MetaReferenceTreeViewItem();
            ((MetaReferenceTreeViewItem)meta).applyConfig(rItem, handler);
            this.addReferenceTreeViewItem((MetaReferenceTreeViewItem)meta);
        }
        this.mapping = new ArrayList<MetaTreeViewGridColModelMapping>();
        if (item.getMapping() != null) {
            for (TreeViewGridColModelMapping modelMapping : item.getMapping()) {
                meta = new MetaTreeViewGridColModelMapping();
                ((MetaTreeViewGridColModelMapping)meta).applyConfig(modelMapping);
                this.addMapping((MetaTreeViewGridColModelMapping)meta);
            }
        }
    }

    public abstract TreeViewItem currentConfig();

    protected void fillTo(TreeViewItem item) {
        EntityContext ctx = EntityContext.getCurrentContext();
        EntityHandler handler = ctx.getHandlerById(this.definitionId);
        PropertyHandler property = handler.getPropertyById(this.displayPropertyId, ctx);
        PropertyHandler sortProperty = null;
        if (this.sortItem != null) {
            sortProperty = handler.getPropertyById(this.sortItem, ctx);
        }
        item.setDefName(handler.getMetaData().getName());
        item.setAction(this.action);
        item.setViewName(this.viewName);
        item.setSortItem(sortProperty != null ? sortProperty.getName() : null);
        item.setSortType(this.sortType);
        item.setLimit(this.limit);
        item.setDisplayPropertyName(property.getName());
        item.setDisplayDefinitionNode(this.displayDefinitionNode);
        item.setEntityNodeIcon(this.entityNodeIcon);
        item.setIndexNodeIcon(this.indexNodeIcon);
        item.setEntityDefinitionNodeIcon(this.entityDefinitionNodeIcon);
        item.setEntityNodeCssStyle(this.entityNodeCssStyle);
        item.setIndexNodeCssStyle(this.indexNodeCssStyle);
        item.setEntityDefinitionNodeCssStyle(this.entityDefinitionNodeCssStyle);
        for (MetaReferenceTreeViewItem rItem : this.getReferenceTreeViewItems()) {
            item.addReferenceTreeItem(rItem.currentConfig(handler));
        }
        if (!this.getMapping().isEmpty()) {
            for (MetaTreeViewGridColModelMapping meta : this.getMapping()) {
                item.addMapping(meta.currentConfig());
            }
        }
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }
}

