/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.generic;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.ValidateError;

public class BulkOperationContext {
    private List<ValidateError> errors;
    private List<Entity> entities;

    public BulkOperationContext(List<Entity> entities) {
        this.entities = entities;
    }

    public BulkOperationContext(List<Entity> entities, List<ValidateError> errors) {
        this.errors = errors;
        this.entities = entities;
    }

    public List<ValidateError> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidateError>();
        }
        return this.errors;
    }

    public void setErrors(List<ValidateError> errors) {
        this.errors = errors;
    }

    public void addError(ValidateError error) {
        for (ValidateError e : this.getErrors()) {
            if (!e.getPropertyName().equals(error.getPropertyName())) continue;
            e.getErrorMessages().addAll(error.getErrorMessages());
            return;
        }
        this.getErrors().add(error);
    }

    public List<Entity> getEntities() {
        if (this.entities == null) {
            this.entities = new ArrayList<Entity>();
        }
        return this.entities;
    }

    public void setEntities(List<Entity> entities) {
        this.entities = entities;
    }
}

