/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.definition.Definition;
import org.iplass.mtp.view.generic.BulkFormView;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.FormView;
import org.iplass.mtp.view.generic.SearchFormView;
import org.iplass.mtp.view.generic.ViewControlSetting;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EntityView
implements Definition {
    private static final long serialVersionUID = -3739791401558711906L;
    private String name;
    private String displayName;
    private String description;
    private String definitionName;
    @MultiLang(isMultiLangValue=false)
    private List<FormView> views;
    private List<ViewControlSetting> viewControlSettings;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public List<FormView> getViews() {
        if (this.views == null) {
            this.views = new ArrayList<FormView>();
        }
        return this.views;
    }

    public void setViews(List<FormView> views) {
        this.views = views;
    }

    public void addView(FormView view) {
        this.getViews().add(view);
    }

    public void removeView(FormView view) {
        if (this.views != null) {
            this.views.remove(view);
        }
    }

    public List<ViewControlSetting> getViewControlSettings() {
        if (this.viewControlSettings == null) {
            this.viewControlSettings = new ArrayList<ViewControlSetting>();
        }
        return this.viewControlSettings;
    }

    public void setViewControlSettings(List<ViewControlSetting> viewControlSettings) {
        this.viewControlSettings = viewControlSettings;
    }

    public void addViewControlSetting(ViewControlSetting viewControlSetting) {
        this.getViewControlSettings().add(viewControlSetting);
    }

    public DetailFormView getDefaultDetailFormView() {
        return this.getDetailFormViewByName(null);
    }

    public DetailFormView getDetailFormView(String name) {
        return this.getDetailFormViewByName(name);
    }

    private DetailFormView getDetailFormViewByName(String name) {
        DetailFormView view = null;
        if (this.getViews() != null && this.getViews().size() > 0) {
            for (FormView fv : this.getViews()) {
                if (!(fv instanceof DetailFormView)) continue;
                if (name == null || name.isEmpty()) {
                    if (fv.getName() == null || fv.getName().equals("")) {
                        view = (DetailFormView)fv;
                    }
                } else if (name.equals(fv.getName())) {
                    view = (DetailFormView)fv;
                }
                if (view == null) continue;
                break;
            }
        }
        return view;
    }

    public String[] getDetailFormViewNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FormView fv : this.getViews()) {
            if (!(fv instanceof DetailFormView)) continue;
            if (fv.getName() == null) {
                names.add("");
                continue;
            }
            names.add(fv.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void setDefaultDetailFormView(DetailFormView formView) {
        DetailFormView fv = this.getDefaultDetailFormView();
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void setDetailFormView(DetailFormView formView) {
        DetailFormView fv = this.getDetailFormView(formView.getName());
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void removeDetailForView(String name) {
        DetailFormView form = null;
        form = name == null || name.equals("") ? this.getDefaultDetailFormView() : this.getDetailFormView(name);
        if (form != null) {
            this.removeDetailForView(form);
        }
    }

    public void removeDetailForView(DetailFormView formView) {
        if (formView == null) {
            throw new IllegalArgumentException("FormView is null.");
        }
        this.removeView(formView);
    }

    public SearchFormView getDefaultSearchFormView() {
        return this.getSearchFormViewByName(null);
    }

    public SearchFormView getSearchFormView(String name) {
        return this.getSearchFormViewByName(name);
    }

    private SearchFormView getSearchFormViewByName(String name) {
        SearchFormView view = null;
        if (this.getViews() != null && this.getViews().size() > 0) {
            for (FormView fv : this.getViews()) {
                if (!(fv instanceof SearchFormView)) continue;
                if (name == null || name.isEmpty()) {
                    if (fv.getName() == null || fv.getName().equals("")) {
                        view = (SearchFormView)fv;
                    }
                } else if (name.equals(fv.getName())) {
                    view = (SearchFormView)fv;
                }
                if (view == null) continue;
                break;
            }
        }
        return view;
    }

    public String[] getSearchFormViewNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FormView fv : this.getViews()) {
            if (!(fv instanceof SearchFormView)) continue;
            if (fv.getName() == null) {
                names.add("");
                continue;
            }
            names.add(fv.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void setDefaultSearchFormView(SearchFormView formView) {
        SearchFormView fv = this.getDefaultSearchFormView();
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void setSearchFormView(SearchFormView formView) {
        SearchFormView fv = this.getSearchFormView(formView.getName());
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void removeSearchForView(String name) {
        SearchFormView form = null;
        form = name == null || name.equals("") ? this.getDefaultSearchFormView() : this.getSearchFormView(name);
        if (form != null) {
            this.removeSearchForView(form);
        }
    }

    public void removeSearchForView(SearchFormView formView) {
        if (formView == null) {
            throw new IllegalArgumentException("FormView is null.");
        }
        this.removeView(formView);
    }

    public BulkFormView getDefaultBulkFormView() {
        return this.getBulkFormViewByName(null);
    }

    public BulkFormView getBulkFormView(String name) {
        return this.getBulkFormViewByName(name);
    }

    private BulkFormView getBulkFormViewByName(String name) {
        BulkFormView view = null;
        if (this.getViews() != null && this.getViews().size() > 0) {
            for (FormView fv : this.getViews()) {
                if (!(fv instanceof BulkFormView)) continue;
                if (name == null || name.isEmpty()) {
                    if (fv.getName() == null || fv.getName().equals("")) {
                        view = (BulkFormView)fv;
                    }
                } else if (name.equals(fv.getName())) {
                    view = (BulkFormView)fv;
                }
                if (view == null) continue;
                break;
            }
        }
        return view;
    }

    public String[] getBulkFormViewNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FormView fv : this.getViews()) {
            if (!(fv instanceof BulkFormView)) continue;
            if (fv.getName() == null) {
                names.add("");
                continue;
            }
            names.add(fv.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public void setDefaultBulkFormView(BulkFormView formView) {
        BulkFormView fv = this.getDefaultBulkFormView();
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void setBulkFormView(BulkFormView formView) {
        BulkFormView fv = this.getBulkFormView(formView.getName());
        if (fv != null) {
            this.removeView(fv);
        }
        this.addView(formView);
    }

    public void removeBulkForView(String name) {
        BulkFormView form = null;
        form = name == null || name.equals("") ? this.getDefaultBulkFormView() : this.getBulkFormView(name);
        if (form != null) {
            this.removeDetailForView(form);
        }
    }

    public void removeDetailForView(BulkFormView formView) {
        if (formView == null) {
            throw new IllegalArgumentException("FormView is null.");
        }
        this.removeView(formView);
    }

    public boolean isAutoGenerateDetailView(String viewName) {
        Optional<ViewControlSetting> setting = this.getViewControlSetting(viewName);
        if (setting.isPresent()) {
            return setting.get().isAutoGenerateDetailView();
        }
        return false;
    }

    public boolean isAutoGenerateSearchView(String viewName) {
        Optional<ViewControlSetting> setting = this.getViewControlSetting(viewName);
        if (setting.isPresent()) {
            return setting.get().isAutoGenerateSearchView();
        }
        return false;
    }

    public boolean isAutoGenerateBulkView(String viewName) {
        Optional<ViewControlSetting> setting = this.getViewControlSetting(viewName);
        if (setting.isPresent()) {
            return setting.get().isAutoGenerateBulkView();
        }
        return false;
    }

    private Optional<ViewControlSetting> getViewControlSetting(String viewName) {
        return this.getViewControlSettings().stream().filter(s -> {
            if (viewName == null || viewName.isEmpty()) {
                return s.getName() == null || s.getName().isEmpty();
            }
            return viewName.equals(s.getName());
        }).findFirst();
    }
}

