/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.view.generic;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.LocalizedStringDefinition;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.LocalizedSelectValueDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.view.generic.parser.Parser;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.ResourceBundleUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.view.generic.DetailFormView;
import org.iplass.mtp.view.generic.EntityViewManager;
import org.iplass.mtp.view.generic.Jsp;
import org.iplass.mtp.view.generic.Jsps;
import org.iplass.mtp.view.generic.OutputType;
import org.iplass.mtp.view.generic.editor.BooleanPropertyEditor;
import org.iplass.mtp.view.generic.editor.DatePropertyEditor;
import org.iplass.mtp.view.generic.editor.DecimalPropertyEditor;
import org.iplass.mtp.view.generic.editor.EditorValue;
import org.iplass.mtp.view.generic.editor.FloatPropertyEditor;
import org.iplass.mtp.view.generic.editor.IntegerPropertyEditor;
import org.iplass.mtp.view.generic.editor.JoinPropertyEditor;
import org.iplass.mtp.view.generic.editor.NestProperty;
import org.iplass.mtp.view.generic.editor.PropertyEditor;
import org.iplass.mtp.view.generic.editor.SelectPropertyEditor;
import org.iplass.mtp.view.generic.editor.StringPropertyEditor;
import org.iplass.mtp.view.generic.editor.TemplatePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimePropertyEditor;
import org.iplass.mtp.view.generic.editor.TimestampPropertyEditor;
import org.iplass.mtp.view.generic.editor.UserPropertyEditor;
import org.iplass.mtp.view.generic.element.Element;
import org.iplass.mtp.view.generic.element.VirtualPropertyItem;
import org.iplass.mtp.view.generic.element.section.DefaultSection;
import org.iplass.mtp.view.generic.element.section.ReferenceSection;
import org.iplass.mtp.view.generic.parser.Token;
import org.iplass.mtp.web.template.TemplateUtil;

public class EntityViewUtil {
    public static boolean isDisplayElement(String definitionName, String elementRuntimeId, OutputType outputType, Entity entity) {
        EntityViewManager evm = (EntityViewManager)ManagerLocator.manager(EntityViewManager.class);
        return evm.isDisplayElement(definitionName, elementRuntimeId, outputType, entity);
    }

    public static String getJspPath(Element element) {
        return EntityViewUtil.getJspPath(element, "");
    }

    public static String getJspPath(Element element, String key) {
        Jsp jsp;
        Jsps jsps = element.getClass().getAnnotation(Jsps.class);
        if (jsps != null) {
            for (Jsp jsp2 : jsps.value()) {
                if (!key.equals(jsp2.key())) continue;
                return jsp2.path();
            }
        }
        if ((jsp = element.getClass().getAnnotation(Jsp.class)) != null) {
            return jsp.path();
        }
        return null;
    }

    public static String getJspPath(PropertyEditor editor) {
        return EntityViewUtil.getJspPath(editor, "");
    }

    public static String getJspPath(PropertyEditor editor, String key) {
        Jsp jsp;
        Jsps jsps = editor.getClass().getAnnotation(Jsps.class);
        if (jsps != null) {
            for (Jsp jsp2 : jsps.value()) {
                if (!key.equals(jsp2.key())) continue;
                return jsp2.path();
            }
        }
        if ((jsp = editor.getClass().getAnnotation(Jsp.class)) != null) {
            return jsp.path();
        }
        return null;
    }

    public static List<Token> perse(JoinPropertyEditor editor) throws IOException {
        Parser parser = new Parser(editor.getJoinProperties());
        return parser.parse(editor.getFormat());
    }

    public static ValidateError[] collectNestPropertyErrors(JoinPropertyEditor editor, String prefix, ValidateError[] errors) {
        ValidateError[] validateErrorArray;
        ValidateError error = new ValidateError();
        error.setErrorCodes(new ArrayList());
        error.setErrorMessages(new ArrayList());
        if (StringUtil.isNotBlank((String)prefix)) {
            error.setPropertyName("join_" + prefix + "." + editor.getPropertyName());
        } else {
            error.setPropertyName("join_" + editor.getPropertyName());
        }
        List<String> nestPropNames = EntityViewUtil.collectNestPropertyNames(editor, prefix);
        nestPropNames.stream().map(propName -> Arrays.stream(errors).filter(err -> {
            String name = err.getPropertyName();
            if (name.equals(propName) || name.startsWith(propName + ".")) {
                return true;
            }
            int firstIndex = -1;
            if (name.startsWith(propName + "[") && (firstIndex = name.indexOf("]", propName.length() + 1)) > -1) {
                return firstIndex + 1 >= name.length() || name.charAt(firstIndex + 1) == '.';
            }
            return false;
        }).collect(Collectors.toList())).flatMap(Collection::stream).forEach(err -> {
            for (int i = 0; i < err.getErrorMessages().size(); ++i) {
                String errorCode;
                String errorMessage = (String)err.getErrorMessages().get(i);
                String string = errorCode = i < err.getErrorCodes().size() ? (String)err.getErrorCodes().get(i) : "";
                if (errorCode.length() > 0 && error.getErrorCodes().contains(errorCode) || error.getErrorMessages().contains(errorMessage)) continue;
                error.addErrorMessage(errorMessage, errorCode);
            }
        });
        if (error.getErrorMessages().size() > 0) {
            ValidateError[] validateErrorArray2 = new ValidateError[1];
            validateErrorArray = validateErrorArray2;
            validateErrorArray2[0] = error;
        } else {
            validateErrorArray = null;
        }
        return validateErrorArray;
    }

    private static List<String> collectNestPropertyNames(JoinPropertyEditor editor, String prefix) {
        ArrayList<String> nestPropNames = new ArrayList<String>();
        for (NestProperty np : editor.getJoinProperties()) {
            if (np.getEditor() instanceof JoinPropertyEditor) {
                JoinPropertyEditor jpe = (JoinPropertyEditor)np.getEditor();
                EntityViewUtil.collectNestPropertyNames(jpe, prefix);
                continue;
            }
            if (StringUtil.isNotBlank((String)prefix)) {
                nestPropNames.add(prefix + "." + np.getPropertyName());
                continue;
            }
            nestPropNames.add(np.getPropertyName());
        }
        return nestPropNames;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getSelectPropertyLabel(List<LocalizedSelectValueDefinition> localizedList, EditorValue editorValue, List<SelectValue> valueList) {
        String value = editorValue.getValue();
        String editorLabel = editorValue.getLabel();
        if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            if (StringUtil.isBlank((String)editorLabel)) {
                if (valueList == null) return null;
                for (SelectValue selectValue : valueList) {
                    if (!selectValue.getValue().equals(value)) continue;
                    return EntityViewUtil.getSelectPropertyLabel(localizedList, value, selectValue.getDisplayName());
                }
                return null;
            }
            if (editorValue.getLocalizedLabelList() == null) return editorLabel;
            for (LocalizedStringDefinition localizedStringDefinition : editorValue.getLocalizedLabelList()) {
                if (!lang.equals(localizedStringDefinition.getLocaleName())) continue;
                return localizedStringDefinition.getStringValue();
            }
            return editorLabel;
        }
        if (!StringUtil.isBlank((String)editorLabel)) {
            return editorLabel;
        }
        if (valueList == null) return null;
        for (SelectValue selectValue : valueList) {
            if (!selectValue.getValue().equals(value)) continue;
            return selectValue.getDisplayName();
        }
        return null;
    }

    public static String getSelectPropertyLabel(List<LocalizedSelectValueDefinition> localizedList, String value, String defaultLabel) {
        if (value == null) {
            return null;
        }
        if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
            if (localizedList != null) {
                String lang = ExecuteContext.getCurrentContext().getLanguage();
                for (LocalizedSelectValueDefinition tmpLsvd : localizedList) {
                    if (!tmpLsvd.getLocaleName().equals(lang)) continue;
                    if (tmpLsvd.getSelectValueList() == null) break;
                    for (SelectValue lsv : tmpLsvd.getSelectValueList()) {
                        if (!value.equals(lsv.getValue())) continue;
                        return lsv.getDisplayName();
                    }
                }
            }
            return defaultLabel;
        }
        return defaultLabel;
    }

    public static List<EditorValue> createEditorValueList(SelectProperty sp, String lang) {
        ArrayList<EditorValue> valueList = null;
        if (sp != null && sp.getSelectValueList() != null) {
            valueList = new ArrayList<EditorValue>();
            for (SelectValue v : sp.getSelectValueList()) {
                EditorValue ev = new EditorValue(v.getDisplayName(), v.getValue());
                if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
                    ArrayList<Object> evlList;
                    if (StringUtil.isEmpty((String)lang)) {
                        if (TemplateUtil.getEnableLanguages() != null) {
                            evlList = new ArrayList<LocalizedStringDefinition>();
                            for (String enableLang : TemplateUtil.getEnableLanguages().keySet()) {
                                SelectValue lsv = sp.getLocalizedSelectValue(v.getValue(), enableLang);
                                if (lsv == null) continue;
                                LocalizedStringDefinition lsd = new LocalizedStringDefinition();
                                lsd.setLocaleName(enableLang);
                                lsd.setStringValue(lsv.getDisplayName());
                                evlList.add(lsd);
                            }
                            ev.setLocalizedLabelList(evlList);
                        }
                    } else {
                        evlList = null;
                        SelectValue lsv = sp.getLocalizedSelectValue(v.getValue(), lang);
                        if (lsv != null) {
                            LocalizedStringDefinition lsd = new LocalizedStringDefinition();
                            lsd.setLocaleName(lang);
                            lsd.setStringValue(lsv.getDisplayName());
                            evlList = new ArrayList();
                            evlList.add(lsd);
                        }
                        ev.setLocalizedLabelList(evlList);
                    }
                }
                valueList.add(ev);
            }
        }
        return valueList;
    }

    public static List<EditorValue> createEditorValueList(SelectValueDefinition svd, String lang) {
        ArrayList<EditorValue> valueList = null;
        if (svd != null && svd.getSelectValueList() != null) {
            valueList = new ArrayList<EditorValue>();
            for (SelectValue v : svd.getSelectValueList()) {
                EditorValue ev = new EditorValue(v.getDisplayName(), v.getValue());
                if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
                    ArrayList<Object> evlList;
                    if (StringUtil.isEmpty((String)lang)) {
                        if (TemplateUtil.getEnableLanguages() != null) {
                            evlList = new ArrayList<LocalizedStringDefinition>();
                            for (String enableLang : TemplateUtil.getEnableLanguages().keySet()) {
                                SelectValue lsv = svd.getLocalizedSelectValue(v.getValue(), enableLang);
                                if (lsv == null) continue;
                                LocalizedStringDefinition lsd = new LocalizedStringDefinition();
                                lsd.setLocaleName(enableLang);
                                lsd.setStringValue(lsv.getDisplayName());
                                evlList.add(lsd);
                            }
                            ev.setLocalizedLabelList(evlList);
                        }
                    } else {
                        evlList = null;
                        SelectValue lsv = svd.getLocalizedSelectValue(v.getValue(), lang);
                        if (lsv != null) {
                            LocalizedStringDefinition lsd = new LocalizedStringDefinition();
                            lsd.setLocaleName(lang);
                            lsd.setStringValue(lsv.getDisplayName());
                            evlList = new ArrayList();
                            evlList.add(lsd);
                        }
                        ev.setLocalizedLabelList(evlList);
                    }
                }
                valueList.add(ev);
            }
        }
        return valueList;
    }

    public static String getStringPropertySelectTypeLabel(EditorValue editorValue) {
        if (((TenantI18nInfo)ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class)).isUseMultilingual()) {
            String lang = ExecuteContext.getCurrentContext().getLanguage();
            if (editorValue.getLocalizedLabelList() != null) {
                for (LocalizedStringDefinition localizedStringDefinition : editorValue.getLocalizedLabelList()) {
                    if (!lang.equals(localizedStringDefinition.getLocaleName())) continue;
                    return localizedStringDefinition.getStringValue();
                }
            }
            return editorValue.getLabel();
        }
        return editorValue.getLabel();
    }

    public static String getDefautlResourceString(String key) {
        return ResourceBundleUtil.resourceString((String)key, (Object[])new Object[0]);
    }

    public static PropertyDefinition getPropertyDefinition(String propName, EntityDefinition entity) {
        if (propName == null || propName.isEmpty()) {
            return null;
        }
        if (propName.contains(".")) {
            int indexOfDot = propName.indexOf(46);
            String objPropName = propName.substring(0, indexOfDot);
            String subPropPath = propName.substring(indexOfDot + 1, propName.length());
            PropertyDefinition property = entity.getProperty(objPropName);
            if (!(property instanceof ReferenceProperty)) {
                throw new IllegalArgumentException("path is invalid:" + objPropName + " is not ObjectReferenceProperty of " + entity.getName());
            }
            ReferenceProperty refProp = (ReferenceProperty)property;
            EntityDefinition refEntity = ((EntityDefinitionManager)ManagerLocator.getInstance().getManager(EntityDefinitionManager.class)).get(refProp.getObjectDefinitionName());
            if (refEntity == null) {
                throw new IllegalArgumentException(objPropName + "'s Entity is not defined.");
            }
            PropertyDefinition refProperty = EntityViewUtil.getPropertyDefinition(subPropPath, refEntity);
            if (refProperty == null) {
                throw new IllegalArgumentException(subPropPath + "'s Property is not defined.");
            }
            return refProperty;
        }
        PropertyDefinition property = entity.getProperty(propName);
        if (property == null) {
            throw new IllegalArgumentException(propName + "'s Property is not defined.");
        }
        return property;
    }

    public static PropertyDefinition getPropertyDefinition(VirtualPropertyItem property) {
        BooleanProperty definition = null;
        if (property.getEditor() instanceof BooleanPropertyEditor) {
            BooleanProperty prop;
            definition = prop = new BooleanProperty(property.getPropertyName());
        } else if (property.getEditor() instanceof DatePropertyEditor) {
            DateProperty prop = new DateProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof TimePropertyEditor) {
            TimeProperty prop = new TimeProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof TimestampPropertyEditor) {
            DateTimeProperty prop = new DateTimeProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof DecimalPropertyEditor) {
            DecimalProperty prop = new DecimalProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof IntegerPropertyEditor) {
            IntegerProperty prop = new IntegerProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof FloatPropertyEditor) {
            FloatProperty prop = new FloatProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof SelectPropertyEditor) {
            SelectProperty prop = new SelectProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof StringPropertyEditor) {
            StringProperty prop = new StringProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof TemplatePropertyEditor) {
            StringProperty prop = new StringProperty(property.getPropertyName());
            definition = prop;
        } else if (property.getEditor() instanceof UserPropertyEditor) {
            StringProperty prop = new StringProperty(property.getPropertyName());
            definition = prop;
        }
        definition.setDisplayName(property.getDisplayLabel());
        definition.setLocalizedDisplayNameList(property.getLocalizedDisplayLabelList());
        definition.setMultiplicity(1);
        definition.setUpdatable(true);
        return definition;
    }

    public static String getCustomStyle(String definitionName, String scriptKey, String editorScriptKey, Entity entity, Object propValue) {
        EntityViewManager evm = (EntityViewManager)ManagerLocator.getInstance().getManager(EntityViewManager.class);
        return evm.getCustomStyle(definitionName, scriptKey, editorScriptKey, entity, propValue);
    }

    public static long referenceSectionCount(DetailFormView view, String propName) {
        return EntityViewUtil.getReferenceSectionList(new ArrayList<ReferenceSection>(), view.getSections()).stream().filter(e -> propName.equals(e.getPropertyName())).count();
    }

    public static List<ReferenceSection> getReferenceSectionList(List<ReferenceSection> sections, List<?> elem) {
        for (Object e : elem) {
            if (e instanceof DefaultSection) {
                EntityViewUtil.getReferenceSectionList(sections, ((DefaultSection)e).getElements());
                continue;
            }
            if (!(e instanceof ReferenceSection)) continue;
            sections.add((ReferenceSection)e);
        }
        return sections;
    }

    public static List<Entity> sortByOrderProperty(List<Entity> entities, String propertyName, boolean research) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        List target = null;
        if (research) {
            List oidList = entities.stream().filter(e -> e.getOid() != null).map(e -> e.getOid()).collect(Collectors.toList());
            if (oidList.isEmpty()) {
                target = entities;
            } else {
                List newEntities = entities.stream().filter(e -> e.getOid() == null).collect(Collectors.toList());
                Query query = new Query().select(new Object[]{"oid", "version", propertyName}).from(entities.get(0).getDefinitionName()).where((Condition)new In("oid", oidList.toArray()));
                target = ((EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class)).searchEntity(query).getList();
                target.addAll(newEntities);
            }
        } else {
            target = entities;
        }
        return EntityViewUtil.sortByOrderProperty(target, propertyName);
    }

    public static List<Entity> sortByOrderProperty(List<Entity> entities, String propertyName) {
        if (entities == null || entities.isEmpty()) {
            return entities;
        }
        List<Entity> ret = entities.stream().map(e -> new SortInfo((Entity)e, propertyName)).sorted(Comparator.comparing(SortInfo::getSortValue, Comparator.nullsLast(Comparator.naturalOrder()))).map(s -> s.getEntity()).collect(Collectors.toList());
        return ret;
    }

    private static class SortInfo {
        private Entity entity;
        private Integer sortValue;

        public SortInfo(Entity entity, String propertyName) {
            this.entity = entity;
            this.sortValue = this.toInteger(entity.getValue(propertyName));
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Integer getSortValue() {
            return this.sortValue;
        }

        private Integer toInteger(Object val) {
            if (val == null) {
                return null;
            }
            if (val instanceof Integer) {
                return (Integer)val;
            }
            if (val instanceof Long) {
                return ((Long)val).intValue();
            }
            if (val instanceof Float) {
                return ((Float)val).intValue();
            }
            if (val instanceof Double) {
                return ((Double)val).intValue();
            }
            if (val instanceof BigDecimal) {
                return ((BigDecimal)val).intValue();
            }
            return -1;
        }
    }
}

